/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.query.DCountInfo;
import com.azure.cosmos.implementation.query.DistinctQueryType;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class QueryInfo
extends JsonSerializable {
    public static final QueryInfo EMPTY = new QueryInfo();
    private static final String HAS_SELECT_VALUE = "hasSelectValue";
    private Integer top;
    private List<SortOrder> orderBy;
    private Collection<AggregateOperator> aggregates;
    private Collection<String> orderByExpressions;
    private String rewrittenQuery;
    private Integer offset;
    private Integer limit;
    private DistinctQueryType distinctQueryType;
    private QueryPlanDiagnosticsContext queryPlanDiagnosticsContext;
    private DCountInfo dCountInfo;
    private boolean nonStreamingOrderBy;

    public QueryInfo() {
    }

    public QueryInfo(ObjectNode objectNode) {
        super(objectNode);
    }

    public QueryInfo(String jsonString) {
        super(jsonString);
    }

    public Integer getTop() {
        return this.top != null ? this.top : (this.top = super.getInt("top"));
    }

    public List<SortOrder> getOrderBy() {
        return this.orderBy != null ? this.orderBy : (this.orderBy = super.getList("orderBy", SortOrder.class, new boolean[0]));
    }

    public String getRewrittenQuery() {
        return this.rewrittenQuery != null ? this.rewrittenQuery : (this.rewrittenQuery = super.getString("rewrittenQuery"));
    }

    public boolean hasTop() {
        return this.getTop() != null;
    }

    public boolean hasOrderBy() {
        List<SortOrder> orderBy = this.getOrderBy();
        return orderBy != null && orderBy.size() > 0;
    }

    public boolean hasRewrittenQuery() {
        return !StringUtils.isEmpty(this.getRewrittenQuery());
    }

    public boolean hasAggregates() {
        boolean hasAggregates;
        Collection<AggregateOperator> aggregates = this.getAggregates();
        boolean bl = hasAggregates = aggregates != null && aggregates.size() > 0;
        if (hasAggregates) {
            return hasAggregates;
        }
        boolean aggregateAliasMappingNonEmpty = this.getGroupByAliasToAggregateType() != null && !this.getGroupByAliasToAggregateType().values().isEmpty();
        return aggregateAliasMappingNonEmpty;
    }

    public Collection<AggregateOperator> getAggregates() {
        return this.aggregates != null ? this.aggregates : (this.aggregates = super.getCollection("aggregates", AggregateOperator.class, new boolean[0]));
    }

    public Collection<String> getOrderByExpressions() {
        return this.orderByExpressions != null ? this.orderByExpressions : (this.orderByExpressions = super.getCollection("orderByExpressions", String.class, new boolean[0]));
    }

    public boolean hasSelectValue() {
        return super.has(HAS_SELECT_VALUE) && Boolean.TRUE.equals(super.getBoolean(HAS_SELECT_VALUE));
    }

    public boolean hasOffset() {
        return this.getOffset() != null;
    }

    public boolean hasLimit() {
        return this.getLimit() != null;
    }

    public Integer getLimit() {
        return this.limit != null ? this.limit : (this.limit = super.getInt("limit"));
    }

    public Integer getOffset() {
        return this.offset != null ? this.offset : (this.offset = super.getInt("offset"));
    }

    public boolean hasDistinct() {
        return this.getDistinctQueryType() != DistinctQueryType.NONE;
    }

    public DistinctQueryType getDistinctQueryType() {
        if (this.distinctQueryType != null) {
            return this.distinctQueryType;
        }
        String distinctType = super.getString("distinctType");
        if (distinctType == null) {
            return DistinctQueryType.NONE;
        }
        switch (distinctType) {
            case "Ordered": {
                this.distinctQueryType = DistinctQueryType.ORDERED;
                break;
            }
            case "Unordered": {
                this.distinctQueryType = DistinctQueryType.UNORDERED;
                break;
            }
            default: {
                this.distinctQueryType = DistinctQueryType.NONE;
            }
        }
        return this.distinctQueryType;
    }

    public boolean hasGroupBy() {
        List<String> groupByExpressions = super.getList("groupByExpressions", String.class, new boolean[0]);
        return groupByExpressions != null && !groupByExpressions.isEmpty();
    }

    public boolean hasNonStreamingOrderBy() {
        this.nonStreamingOrderBy = Boolean.TRUE.equals(super.getBoolean("hasNonStreamingOrderBy"));
        return this.nonStreamingOrderBy;
    }

    public Map<String, AggregateOperator> getGroupByAliasToAggregateType() {
        Map<String, AggregateOperator> groupByAliasToAggregateMap = super.getMap("groupByAliasToAggregateType");
        return groupByAliasToAggregateMap;
    }

    public List<String> getGroupByAliases() {
        return super.getList("groupByAliases", String.class, new boolean[0]);
    }

    public boolean hasDCount() {
        return this.getDCountInfo() != null;
    }

    public DCountInfo getDCountInfo() {
        return this.dCountInfo != null ? this.dCountInfo : (this.dCountInfo = super.getObject("dCountInfo", DCountInfo.class, new boolean[0]));
    }

    public String getDCountAlias() {
        return this.dCountInfo.getDCountAlias();
    }

    public boolean isValueAggregate() {
        return Strings.isNullOrEmpty(this.getDCountAlias());
    }

    public QueryPlanDiagnosticsContext getQueryPlanDiagnosticsContext() {
        return this.queryPlanDiagnosticsContext;
    }

    public void setQueryPlanDiagnosticsContext(QueryPlanDiagnosticsContext queryPlanDiagnosticsContext) {
        this.queryPlanDiagnosticsContext = queryPlanDiagnosticsContext;
    }

    public void setOrderByExpressions(List<String> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
        super.set("orderByExpressions", orderByExpressions, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public void setRewrittenQuery(String rewrittenQuery) {
        this.rewrittenQuery = rewrittenQuery;
        super.set("rewrittenQuery", rewrittenQuery, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public void setOrderBy(List<SortOrder> orderBy) {
        this.orderBy = orderBy;
        super.set("orderBy", orderBy, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final class QueryPlanDiagnosticsContext {
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private volatile Instant startTimeUTC;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private volatile Instant endTimeUTC;
        private volatile RequestTimeline requestTimeline;

        public QueryPlanDiagnosticsContext(Instant startTimeUTC, Instant endTimeUTC) {
            this.startTimeUTC = startTimeUTC;
            this.endTimeUTC = endTimeUTC;
        }

        public QueryPlanDiagnosticsContext(Instant startTimeUTC, Instant endTimeUTC, RequestTimeline requestTimeline) {
            this.startTimeUTC = startTimeUTC;
            this.endTimeUTC = endTimeUTC;
            this.requestTimeline = requestTimeline;
        }

        public Instant getStartTimeUTC() {
            return this.startTimeUTC;
        }

        public Instant getEndTimeUTC() {
            return this.endTimeUTC;
        }

        @JsonIgnore
        public Duration getDuration() {
            if (this.startTimeUTC == null || this.endTimeUTC == null || this.endTimeUTC.isBefore(this.startTimeUTC)) {
                return null;
            }
            return Duration.between(this.startTimeUTC, this.endTimeUTC);
        }

        public RequestTimeline getRequestTimeline() {
            return this.requestTimeline;
        }
    }
}

