/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.QueryFeature;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;

class QueryPlanRetriever {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor qryOptAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final String TRUE = "True";
    private static final String SUPPORTED_QUERY_FEATURES = QueryFeature.Aggregate.name() + ", " + QueryFeature.CompositeAggregate.name() + ", " + QueryFeature.MultipleOrderBy.name() + ", " + QueryFeature.MultipleAggregates.name() + ", " + QueryFeature.OrderBy.name() + ", " + QueryFeature.OffsetAndLimit.name() + ", " + QueryFeature.Distinct.name() + ", " + QueryFeature.GroupBy.name() + ", " + QueryFeature.Top.name() + ", " + QueryFeature.DCount.name() + ", " + QueryFeature.NonValueAggregate.name() + ", " + QueryFeature.NonStreamingOrderBy.name() + ", " + QueryFeature.HybridSearch.name();
    private static final String OLD_SUPPORTED_QUERY_FEATURES = QueryFeature.Aggregate.name() + ", " + QueryFeature.CompositeAggregate.name() + ", " + QueryFeature.MultipleOrderBy.name() + ", " + QueryFeature.MultipleAggregates.name() + ", " + QueryFeature.OrderBy.name() + ", " + QueryFeature.OffsetAndLimit.name() + ", " + QueryFeature.Distinct.name() + ", " + QueryFeature.GroupBy.name() + ", " + QueryFeature.Top.name() + ", " + QueryFeature.DCount.name() + ", " + QueryFeature.NonValueAggregate.name();

    QueryPlanRetriever() {
    }

    static Mono<PartitionedQueryExecutionInfo> getQueryPlanThroughGatewayAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, SqlQuerySpec sqlQuerySpec, String resourceLink, CosmosQueryRequestOptions initialQueryRequestOptions) {
        CosmosQueryRequestOptions nonNullRequestOptions = initialQueryRequestOptions != null ? initialQueryRequestOptions : new CosmosQueryRequestOptions();
        PartitionKey partitionKey = nonNullRequestOptions.getPartitionKey();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        requestHeaders.put("x-ms-cosmos-is-query-plan-request", TRUE);
        requestHeaders.put("x-ms-cosmos-supported-query-features", Configs.getAzureCosmosNonStreamingOrderByDisabled() ? OLD_SUPPORTED_QUERY_FEATURES : SUPPORTED_QUERY_FEATURES);
        requestHeaders.put("x-ms-cosmos-query-version", "1.0");
        if (partitionKey != null && partitionKey != PartitionKey.NONE) {
            PartitionKeyInternal partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(partitionKey);
            requestHeaders.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
        }
        RxDocumentServiceRequest queryPlanRequest = RxDocumentServiceRequest.create(diagnosticsClientContext, OperationType.QueryPlan, ResourceType.Document, resourceLink, requestHeaders);
        queryPlanRequest.useGatewayMode = true;
        queryPlanRequest.setByteBuffer(ModelBridgeInternal.serializeJsonToByteBuffer(sqlQuerySpec));
        CosmosEndToEndOperationLatencyPolicyConfig end2EndConfig = qryOptAccessor.getImpl(nonNullRequestOptions).getCosmosEndToEndLatencyPolicyConfig();
        if (end2EndConfig != null) {
            queryPlanRequest.requestContext.setEndToEndOperationLatencyPolicyConfig(end2EndConfig);
        }
        BiFunction executeFunc = (retryPolicyFactory, req) -> {
            DocumentClientRetryPolicy retryPolicyInstance = (DocumentClientRetryPolicy)retryPolicyFactory.get();
            retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            return BackoffRetryUtility.executeRetry(() -> queryClient.executeQueryAsync((RxDocumentServiceRequest)req).flatMap(rxDocumentServiceResponse -> {
                PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo((ObjectNode)rxDocumentServiceResponse.getResponseBody(), rxDocumentServiceResponse.getGatewayHttpRequestTimeline());
                return Mono.just((Object)partitionedQueryExecutionInfo);
            }), retryPolicyInstance);
        };
        return queryClient.executeFeedOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.QueryPlan, () -> queryClient.getResetSessionTokenRetryPolicy().getRequestPolicy(diagnosticsClientContext), queryPlanRequest, executeFunc, PathsHelper.getCollectionPath(resourceLink));
    }
}

