/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import java.util.HashMap;
import java.util.Map;

public class RegionNameToRegionIdMap {
    public static final Map<String, Integer> REGION_NAME_TO_REGION_ID_MAPPINGS = new HashMap<String, Integer>(){
        {
            this.put("East US", 1);
            this.put("East US 2", 2);
            this.put("Central US", 3);
            this.put("North Central US", 4);
            this.put("South Central US", 5);
            this.put("West Central US", 6);
            this.put("West US", 7);
            this.put("West US 2", 8);
            this.put("Canada East", 9);
            this.put("Canada Central", 10);
            this.put("Brazil South", 11);
            this.put("North Europe", 12);
            this.put("West Europe", 13);
            this.put("France Central", 14);
            this.put("France South", 15);
            this.put("UK West", 16);
            this.put("UK South", 17);
            this.put("Germany Central", 18);
            this.put("Germany Northeast", 19);
            this.put("Germany North", 20);
            this.put("Germany West Central", 21);
            this.put("Switzerland North", 22);
            this.put("Switzerland West", 23);
            this.put("Southeast Asia", 24);
            this.put("East Asia", 25);
            this.put("Australia East", 26);
            this.put("Australia Southeast", 27);
            this.put("Australia Central", 28);
            this.put("Australia Central 2", 29);
            this.put("China East", 30);
            this.put("China North", 31);
            this.put("Central India", 32);
            this.put("West India", 33);
            this.put("South India", 34);
            this.put("Japan East", 35);
            this.put("Japan West", 36);
            this.put("Korea Central", 37);
            this.put("Korea South", 38);
            this.put("USGov Virginia", 39);
            this.put("USGov Iowa", 40);
            this.put("USGov Arizona", 41);
            this.put("USGov Texas", 42);
            this.put("USDoD East", 43);
            this.put("USDoD Central", 44);
            this.put("USSec East", 45);
            this.put("USSec West", 46);
            this.put("South Africa West", 47);
            this.put("South Africa North", 48);
            this.put("UAE Central", 49);
            this.put("UAE North", 50);
            this.put("Central US EUAP", 51);
            this.put("East US 2 EUAP", 52);
            this.put("North Europe 2", 53);
            this.put("easteurope", 54);
            this.put("APAC Southeast 2", 55);
            this.put("UK South 2", 56);
            this.put("UK North", 57);
            this.put("East US STG", 58);
            this.put("South Central US STG", 59);
            this.put("Norway East", 60);
            this.put("Norway West", 61);
            this.put("USGov Wyoming", 62);
            this.put("USDoD Southwest", 63);
            this.put("USDoD West Central", 64);
            this.put("USDoD South Central", 65);
            this.put("China East 2", 66);
            this.put("China North 2", 67);
            this.put("USNat East", 68);
            this.put("USNat West", 69);
            this.put("China North 10", 70);
            this.put("Sweden Central", 71);
            this.put("Sweden South", 72);
            this.put("Korea South 2", 73);
            this.put("USSec West Central", 113);
        }
    };
    public static final Map<Integer, String> REGION_ID_TO_NORMALIZED_REGION_NAME_MAPPINGS = new HashMap<Integer, String>(){
        {
            this.put(49, "uaecentral");
            this.put(14, "francecentral");
            this.put(65, "usdodsouthcentral");
            this.put(26, "australiaeast");
            this.put(27, "australiasoutheast");
            this.put(16, "ukwest");
            this.put(40, "usgoviowa");
            this.put(72, "swedensouth");
            this.put(69, "usnatwest");
            this.put(13, "westeurope");
            this.put(50, "uaenorth");
            this.put(53, "northeurope2");
            this.put(36, "japanwest");
            this.put(5, "southcentralus");
            this.put(37, "koreacentral");
            this.put(60, "norwayeast");
            this.put(11, "brazilsouth");
            this.put(29, "australiacentral2");
            this.put(28, "australiacentral");
            this.put(73, "koreasouth2");
            this.put(32, "centralindia");
            this.put(35, "japaneast");
            this.put(45, "usseceast");
            this.put(25, "eastasia");
            this.put(6, "westcentralus");
            this.put(19, "germanynortheast");
            this.put(23, "switzerlandwest");
            this.put(52, "eastus2euap");
            this.put(8, "westus2");
            this.put(43, "usdodeast");
            this.put(17, "uksouth");
            this.put(56, "uksouth2");
            this.put(10, "canadacentral");
            this.put(68, "usnateast");
            this.put(20, "germanynorth");
            this.put(9, "canadaeast");
            this.put(67, "chinanorth2");
            this.put(22, "switzerlandnorth");
            this.put(58, "eastusstg");
            this.put(1, "eastus");
            this.put(57, "uknorth");
            this.put(4, "northcentralus");
            this.put(54, "easteurope");
            this.put(42, "usgovtexas");
            this.put(61, "norwaywest");
            this.put(55, "apacsoutheast2");
            this.put(12, "northeurope");
            this.put(59, "southcentralusstg");
            this.put(21, "germanywestcentral");
            this.put(24, "southeastasia");
            this.put(71, "swedencentral");
            this.put(31, "chinanorth");
            this.put(62, "usgovwyoming");
            this.put(30, "chinaeast");
            this.put(2, "eastus2");
            this.put(34, "southindia");
            this.put(51, "centraluseuap");
            this.put(18, "germanycentral");
            this.put(7, "westus");
            this.put(44, "usdodcentral");
            this.put(66, "chinaeast2");
            this.put(39, "usgovvirginia");
            this.put(64, "usdodwestcentral");
            this.put(70, "chinanorth10");
            this.put(41, "usgovarizona");
            this.put(33, "westindia");
            this.put(38, "koreasouth");
            this.put(3, "centralus");
            this.put(63, "usdodsouthwest");
            this.put(47, "southafricawest");
            this.put(46, "ussecwest");
            this.put(15, "francesouth");
            this.put(48, "southafricanorth");
            this.put(113, "ussecwestcentral");
        }
    };
    public static final Map<String, Integer> NORMALIZED_REGION_NAME_TO_REGION_ID_MAPPINGS = new HashMap<String, Integer>(){
        {
            this.put("southafricanorth", 48);
            this.put("westus2", 8);
            this.put("australiacentral", 28);
            this.put("apacsoutheast2", 55);
            this.put("eastasia", 25);
            this.put("uknorth", 57);
            this.put("francecentral", 14);
            this.put("southafricawest", 47);
            this.put("usgovtexas", 42);
            this.put("koreacentral", 37);
            this.put("centralus", 3);
            this.put("japaneast", 35);
            this.put("westeurope", 13);
            this.put("norwayeast", 60);
            this.put("eastus", 1);
            this.put("australiasoutheast", 27);
            this.put("centralindia", 32);
            this.put("usdodeast", 43);
            this.put("germanycentral", 18);
            this.put("usdodwestcentral", 64);
            this.put("switzerlandwest", 23);
            this.put("chinaeast2", 66);
            this.put("westus", 7);
            this.put("northcentralus", 4);
            this.put("usdodcentral", 44);
            this.put("uaenorth", 50);
            this.put("centraluseuap", 51);
            this.put("germanywestcentral", 21);
            this.put("ussecwest", 46);
            this.put("usnateast", 68);
            this.put("uksouth", 17);
            this.put("usgovvirginia", 39);
            this.put("usgoviowa", 40);
            this.put("chinanorth2", 67);
            this.put("germanynorth", 20);
            this.put("easteurope", 54);
            this.put("uksouth2", 56);
            this.put("ukwest", 16);
            this.put("japanwest", 36);
            this.put("usdodsouthcentral", 65);
            this.put("australiaeast", 26);
            this.put("westindia", 33);
            this.put("australiacentral2", 29);
            this.put("southindia", 34);
            this.put("eastus2euap", 52);
            this.put("canadaeast", 9);
            this.put("southeastasia", 24);
            this.put("koreasouth", 38);
            this.put("southcentralus", 5);
            this.put("eastusstg", 58);
            this.put("chinanorth10", 70);
            this.put("swedensouth", 72);
            this.put("westcentralus", 6);
            this.put("eastus2", 2);
            this.put("chinaeast", 30);
            this.put("usgovarizona", 41);
            this.put("norwaywest", 61);
            this.put("uaecentral", 49);
            this.put("swedencentral", 71);
            this.put("usdodsouthwest", 63);
            this.put("usnatwest", 69);
            this.put("chinanorth", 31);
            this.put("northeurope2", 53);
            this.put("usgovwyoming", 62);
            this.put("brazilsouth", 11);
            this.put("koreasouth2", 73);
            this.put("canadacentral", 10);
            this.put("southcentralusstg", 59);
            this.put("usseceast", 45);
            this.put("francesouth", 15);
            this.put("germanynortheast", 19);
            this.put("switzerlandnorth", 22);
            this.put("northeurope", 12);
            this.put("ussecwestcentral", 113);
        }
    };

    public static String getRegionName(int regionId) {
        return REGION_ID_TO_NORMALIZED_REGION_NAME_MAPPINGS.getOrDefault(regionId, "");
    }

    public static int getRegionId(String regionName) {
        return NORMALIZED_REGION_NAME_TO_REGION_ID_MAPPINGS.getOrDefault(regionName, -1);
    }
}

