/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.FeedOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PointOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.circuitBreaker.LocationSpecificHealthContext;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class DocumentServiceRequestContext
implements Cloneable {
    public volatile boolean forceAddressRefresh;
    public volatile boolean forceRefreshAddressCache;
    public volatile RequestChargeTracker requestChargeTracker;
    public volatile TimeoutHelper timeoutHelper;
    public volatile String resolvedCollectionRid;
    public volatile ISessionToken sessionToken;
    public volatile long quorumSelectedLSN;
    public volatile long globalCommittedSelectedLSN;
    public volatile StoreResponse globalStrongWriteResponse;
    public volatile ConsistencyLevel originalRequestConsistencyLevel;
    public volatile PartitionKeyRange resolvedPartitionKeyRange;
    public volatile PartitionKeyRange resolvedPartitionKeyRangeForCircuitBreaker;
    public volatile Integer regionIndex;
    public volatile Boolean usePreferredLocations;
    public volatile Integer locationIndexToRoute;
    public volatile URI locationEndpointToRoute;
    public volatile boolean performedBackgroundAddressRefresh;
    public volatile boolean performLocalRefreshOnGoneException;
    public volatile List<String> storeResponses;
    public volatile StoreResult quorumSelectedStoreResponse;
    public volatile PartitionKeyInternal effectivePartitionKey;
    public volatile CosmosDiagnostics cosmosDiagnostics;
    public volatile String resourcePhysicalAddress;
    public volatile String throughputControlCycleId;
    public volatile boolean replicaAddressValidationEnabled = Configs.isReplicaAddressValidationEnabled();
    private final Set<Uri> failedEndpoints = ConcurrentHashMap.newKeySet();
    private CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig;
    private AtomicBoolean isRequestCancelledOnTimeout = null;
    private volatile List<String> excludeRegions;
    private volatile Set<String> keywordIdentifiers;
    private volatile long approximateBloomFilterInsertionCount;
    private final Set<String> sessionTokenEvaluationResults = ConcurrentHashMap.newKeySet();
    private volatile List<String> unavailableRegionsForPartition;
    public final Map<String, CosmosException> rntbdCancelledRequestMap = new ConcurrentHashMap<String, CosmosException>();
    private PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker;
    private FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreaker;
    private volatile Supplier<DocumentClientRetryPolicy> clientRetryPolicySupplier;
    private volatile Utils.ValueHolder<Map<String, LocationSpecificHealthContext>> regionToLocationSpecificHealthContext = new Utils.ValueHolder();

    public void routeToLocation(int locationIndex, boolean usePreferredLocations) {
        this.locationIndexToRoute = locationIndex;
        this.usePreferredLocations = usePreferredLocations;
        this.locationEndpointToRoute = null;
    }

    public void routeToLocation(URI locationEndpoint) {
        this.locationEndpointToRoute = locationEndpoint;
        this.locationIndexToRoute = null;
        this.usePreferredLocations = null;
    }

    public void clearRouteToLocation() {
        this.locationIndexToRoute = null;
        this.locationEndpointToRoute = null;
        this.usePreferredLocations = null;
    }

    public Set<Uri> getFailedEndpoints() {
        return this.failedEndpoints;
    }

    public void addToFailedEndpoints(Exception exception, Uri address) {
        CosmosException cosmosException;
        if (exception instanceof CosmosException && Exceptions.isGone(cosmosException = (CosmosException)((Object)exception))) {
            this.failedEndpoints.add(address);
        }
    }

    public DocumentServiceRequestContext clone() {
        DocumentServiceRequestContext context = new DocumentServiceRequestContext();
        context.forceAddressRefresh = this.forceAddressRefresh;
        context.forceRefreshAddressCache = this.forceRefreshAddressCache;
        context.requestChargeTracker = this.requestChargeTracker;
        context.timeoutHelper = this.timeoutHelper;
        context.resolvedCollectionRid = this.resolvedCollectionRid;
        context.sessionToken = this.sessionToken;
        context.quorumSelectedLSN = this.quorumSelectedLSN;
        context.globalCommittedSelectedLSN = this.globalCommittedSelectedLSN;
        context.globalStrongWriteResponse = this.globalStrongWriteResponse;
        context.originalRequestConsistencyLevel = this.originalRequestConsistencyLevel;
        context.resolvedPartitionKeyRange = this.resolvedPartitionKeyRange;
        context.resolvedPartitionKeyRangeForCircuitBreaker = this.resolvedPartitionKeyRangeForCircuitBreaker;
        context.regionIndex = this.regionIndex;
        context.usePreferredLocations = this.usePreferredLocations;
        context.locationIndexToRoute = this.locationIndexToRoute;
        context.locationEndpointToRoute = this.locationEndpointToRoute;
        context.performLocalRefreshOnGoneException = this.performLocalRefreshOnGoneException;
        context.effectivePartitionKey = this.effectivePartitionKey;
        context.performedBackgroundAddressRefresh = this.performedBackgroundAddressRefresh;
        context.cosmosDiagnostics = this.cosmosDiagnostics;
        context.resourcePhysicalAddress = this.resourcePhysicalAddress;
        context.throughputControlCycleId = this.throughputControlCycleId;
        context.replicaAddressValidationEnabled = this.replicaAddressValidationEnabled;
        context.endToEndOperationLatencyPolicyConfig = this.endToEndOperationLatencyPolicyConfig;
        context.unavailableRegionsForPartition = this.unavailableRegionsForPartition;
        context.feedOperationContextForCircuitBreaker = this.feedOperationContextForCircuitBreaker;
        context.pointOperationContextForCircuitBreaker = this.pointOperationContextForCircuitBreaker;
        return context;
    }

    public CosmosEndToEndOperationLatencyPolicyConfig getEndToEndOperationLatencyPolicyConfig() {
        return this.endToEndOperationLatencyPolicyConfig;
    }

    public void setEndToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig) {
        this.endToEndOperationLatencyPolicyConfig = endToEndOperationLatencyPolicyConfig;
    }

    public void setIsRequestCancelledOnTimeout(AtomicBoolean isRequestCancelledOnTimeout) {
        this.isRequestCancelledOnTimeout = isRequestCancelledOnTimeout;
    }

    public AtomicBoolean isRequestCancelledOnTimeout() {
        return this.isRequestCancelledOnTimeout;
    }

    public List<String> getExcludeRegions() {
        return this.excludeRegions;
    }

    public void setExcludeRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
    }

    public List<String> getUnavailableRegionsForPartition() {
        return this.unavailableRegionsForPartition;
    }

    public void setUnavailableRegionsForPartition(List<String> unavailableRegionsForPartition) {
        this.unavailableRegionsForPartition = unavailableRegionsForPartition;
    }

    public PointOperationContextForCircuitBreaker getPointOperationContextForCircuitBreaker() {
        return this.pointOperationContextForCircuitBreaker;
    }

    public void setPointOperationContext(PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        this.pointOperationContextForCircuitBreaker = pointOperationContextForCircuitBreaker;
    }

    public FeedOperationContextForCircuitBreaker getFeedOperationContextForCircuitBreaker() {
        return this.feedOperationContextForCircuitBreaker;
    }

    public void setFeedOperationContext(FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreaker) {
        this.feedOperationContextForCircuitBreaker = feedOperationContextForCircuitBreaker;
    }

    public void setKeywordIdentifiers(Set<String> keywordIdentifiers) {
        this.keywordIdentifiers = keywordIdentifiers;
    }

    public Set<String> getKeywordIdentifiers() {
        return this.keywordIdentifiers;
    }

    public long getApproximateBloomFilterInsertionCount() {
        return this.approximateBloomFilterInsertionCount;
    }

    public void setApproximateBloomFilterInsertionCount(long approximateBloomFilterInsertionCount) {
        this.approximateBloomFilterInsertionCount = approximateBloomFilterInsertionCount;
    }

    public Set<String> getSessionTokenEvaluationResults() {
        return this.sessionTokenEvaluationResults;
    }

    public Supplier<DocumentClientRetryPolicy> getClientRetryPolicySupplier() {
        return this.clientRetryPolicySupplier;
    }

    public void setClientRetryPolicySupplier(Supplier<DocumentClientRetryPolicy> clientRetryPolicySupplier) {
        this.clientRetryPolicySupplier = clientRetryPolicySupplier;
    }

    public Utils.ValueHolder<Map<String, LocationSpecificHealthContext>> getLocationToLocationSpecificHealthContext() {
        return this.regionToLocationSpecificHealthContext;
    }

    public void setLocationToLocationSpecificHealthContext(Map<String, LocationSpecificHealthContext> regionToLocationSpecificHealthContext) {
        this.regionToLocationSpecificHealthContext.v = regionToLocationSpecificHealthContext;
    }
}

