/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.DataType;
import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class SpatialIndex
extends Index {
    SpatialIndex(DataType dataType) {
        super(IndexKind.SPATIAL);
        this.setDataType(dataType);
    }

    public SpatialIndex(String jsonString) {
        super(jsonString, IndexKind.SPATIAL);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    SpatialIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.SPATIAL);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            super.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public SpatialIndex setDataType(DataType dataType) {
        super.set("dataType", dataType.toString(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        return this;
    }
}

