/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Mono<byte[]> cachedBody;

    BufferedHttpResponse(HttpResponse innerHttpResponse) {
        this.innerHttpResponse = innerHttpResponse;
        Mono bodyAsByteArrayMono = innerHttpResponse.body().handle((bb, sink) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink.next((Object)bytes);
            }
            catch (IllegalReferenceCountException var3) {
                sink.complete();
            }
        });
        this.cachedBody = bodyAsByteArrayMono.cache();
        this.withRequest(innerHttpResponse.request());
    }

    @Override
    public int statusCode() {
        return this.innerHttpResponse.statusCode();
    }

    @Override
    public String headerValue(String name) {
        return this.innerHttpResponse.headerValue(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.innerHttpResponse.headers();
    }

    @Override
    public Mono<ByteBuf> body() {
        return this.cachedBody.map(actualCachedByteArray -> Unpooled.wrappedBuffer((byte[])actualCachedByteArray));
    }

    @Override
    public Mono<String> bodyAsString() {
        return this.body().map(buffer -> buffer == null ? null : buffer.toString(StandardCharsets.UTF_8));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

