/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.RequestTimeline;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public final class ReactorNettyRequestRecord {
    private static final AtomicLong instanceCount = new AtomicLong();
    private volatile Instant timeCreated;
    private volatile Instant timeConnected;
    private volatile Instant timeAcquired;
    private volatile Instant timeConfigured;
    private volatile Instant timeSent;
    private volatile Instant timeReceived;
    private volatile Instant timeCompleted;
    private final long transportRequestId = instanceCount.incrementAndGet();

    public Instant timeCreated() {
        return this.timeCreated;
    }

    public Instant timeConnected() {
        return this.timeConnected;
    }

    public Instant timeAcquired() {
        return this.timeAcquired;
    }

    public Instant timeConfigured() {
        return this.timeConfigured;
    }

    public Instant timeSent() {
        return this.timeSent;
    }

    public Instant timeReceived() {
        return this.timeReceived;
    }

    public Instant timeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCreated(Instant timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeConnected(Instant timeConnected) {
        this.timeConnected = timeConnected;
    }

    public void setTimeAcquired(Instant timeAcquired) {
        this.timeAcquired = timeAcquired;
    }

    public void setTimeConfigured(Instant timeConfigured) {
        this.timeConfigured = timeConfigured;
    }

    public void setTimeSent(Instant timeSent) {
        this.timeSent = timeSent;
    }

    public void setTimeReceived(Instant timeReceived) {
        this.timeReceived = timeReceived;
    }

    public void setTimeCompleted(Instant timeCompleted) {
        this.timeCompleted = timeCompleted;
    }

    public RequestTimeline takeTimelineSnapshot() {
        Instant timeCompletedOrNow;
        Instant now = Instant.now();
        Instant timeCreated = this.timeCreated();
        Instant timeAcquired = this.timeAcquired();
        Instant timeConnected = this.timeConnected();
        Instant timeConfigured = this.timeConfigured();
        Instant timeSent = this.timeSent();
        Instant timeReceived = this.timeReceived();
        Instant timeCompleted = this.timeCompleted();
        Instant instant = timeCompletedOrNow = timeCompleted == null ? now : timeCompleted;
        if (this.timeConnected() != null) {
            return RequestTimeline.of(new RequestTimeline.Event(RequestTimeline.EventName.CONNECTION_CREATED, timeCreated, this.timeConnected() == null ? timeCompletedOrNow : timeConnected), new RequestTimeline.Event(RequestTimeline.EventName.CONNECTION_CONFIGURED, timeConnected, timeConfigured == null ? timeCompletedOrNow : timeConfigured), new RequestTimeline.Event(RequestTimeline.EventName.REQUEST_SENT, timeConfigured, timeSent == null ? timeCompletedOrNow : timeSent), new RequestTimeline.Event(RequestTimeline.EventName.TRANSIT_TIME, timeSent, timeReceived == null ? timeCompletedOrNow : timeReceived), new RequestTimeline.Event(RequestTimeline.EventName.RECEIVED, timeReceived, timeCompletedOrNow));
        }
        return RequestTimeline.of(new RequestTimeline.Event(RequestTimeline.EventName.CONNECTION_ACQUIRED, timeCreated, this.timeAcquired() == null ? timeCompletedOrNow : timeAcquired), new RequestTimeline.Event(RequestTimeline.EventName.CONNECTION_CONFIGURED, timeAcquired, timeConfigured == null ? timeCompletedOrNow : timeConfigured), new RequestTimeline.Event(RequestTimeline.EventName.REQUEST_SENT, timeConfigured, timeSent == null ? timeCompletedOrNow : timeSent), new RequestTimeline.Event(RequestTimeline.EventName.TRANSIT_TIME, timeSent, timeReceived == null ? timeCompletedOrNow : timeReceived), new RequestTimeline.Event(RequestTimeline.EventName.RECEIVED, timeReceived, timeCompletedOrNow));
    }

    public long getTransportRequestId() {
        return this.transportRequestId;
    }
}

