/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctContinuationToken;
import com.azure.cosmos.implementation.query.DistinctMap;
import com.azure.cosmos.implementation.query.DistinctQueryType;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.routing.UInt128;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;

public class DistinctDocumentQueryExecutionContext<T>
implements IDocumentQueryExecutionComponent<T> {
    private final IDocumentQueryExecutionComponent<T> component;
    private final DistinctMap distinctMap;
    private final AtomicReference<UInt128> lastHash;

    private DistinctDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, DistinctQueryType distinctQueryType, UInt128 previousHash) {
        if (distinctQueryType == DistinctQueryType.NONE) {
            throw new IllegalArgumentException("Invalid distinct query type");
        }
        if (component == null) {
            throw new IllegalArgumentException("documentQueryExecutionComponent cannot be null");
        }
        this.component = component;
        this.distinctMap = DistinctMap.create(distinctQueryType, previousHash);
        this.lastHash = new AtomicReference();
    }

    public static <T> Flux<IDocumentQueryExecutionComponent<T>> createAsync(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, DistinctQueryType distinctQueryType, String continuationToken, PipelinedDocumentQueryParams<T> documentQueryParams) {
        Utils.ValueHolder<DistinctContinuationToken> outDistinctcontinuationtoken = new Utils.ValueHolder<DistinctContinuationToken>();
        DistinctContinuationToken distinctContinuationToken = new DistinctContinuationToken(null, null);
        if (continuationToken != null) {
            if (!DistinctContinuationToken.tryParse(continuationToken, outDistinctcontinuationtoken)) {
                return Flux.error((Throwable)((Object)new BadRequestException("Invalid DistinctContinuationToken" + continuationToken)));
            }
            distinctContinuationToken = (DistinctContinuationToken)outDistinctcontinuationtoken.v;
            if (distinctQueryType != DistinctQueryType.ORDERED && distinctContinuationToken.getLastHash() != null) {
                BadRequestException dce = new BadRequestException("DistinctContinuationToken is malformed. DistinctContinuationToken can not have a 'lastHash', when the query type is not ordered (ex SELECT DISTINCT VALUE c.blah FROM c ORDER BY c.blah).");
                return Flux.error((Throwable)((Object)dce));
            }
        }
        UInt128 continuationTokenLastHash = distinctContinuationToken.getLastHash();
        return createSourceComponentFunction.apply(distinctContinuationToken.getSourceToken(), documentQueryParams).map(component -> new DistinctDocumentQueryExecutionContext(component, distinctQueryType, continuationTokenLastHash));
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).map(tFeedResponse -> {
            ArrayList distinctResults = new ArrayList();
            tFeedResponse.getResults().forEach(document -> {
                Utils.ValueHolder<UInt128> outHash = new Utils.ValueHolder<UInt128>();
                if (this.distinctMap.add(document, outHash)) {
                    distinctResults.add(document);
                    this.lastHash.set((UInt128)outHash.v);
                }
            });
            HashMap<String, String> headers = new HashMap<String, String>(tFeedResponse.getResponseHeaders());
            if (tFeedResponse.getContinuationToken() != null) {
                String sourceContinuationToken = tFeedResponse.getContinuationToken();
                DistinctContinuationToken distinctContinuationToken = new DistinctContinuationToken(this.lastHash.get(), sourceContinuationToken);
                headers.put("x-ms-continuation", distinctContinuationToken.toJson());
            }
            return BridgeInternal.createFeedResponseWithQueryMetrics(distinctResults, headers, BridgeInternal.queryMetricsFromFeedResponse(tFeedResponse), ModelBridgeInternal.getQueryPlanDiagnosticsContext(tFeedResponse), false, false, tFeedResponse.getCosmosDiagnostics());
        });
    }
}

