/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyClient;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.Http2AllocationStrategy;
import reactor.netty.resources.ConnectionProvider;

public interface HttpClient {
    public Mono<HttpResponse> send(HttpRequest var1);

    public Mono<HttpResponse> send(HttpRequest var1, Duration var2);

    public static HttpClient createFixed(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        ConnectionProvider.Builder fixedConnectionProviderBuilder = ConnectionProvider.builder((String)httpClientConfig.getConnectionPoolName());
        fixedConnectionProviderBuilder.maxConnections(httpClientConfig.getMaxPoolSize());
        fixedConnectionProviderBuilder.pendingAcquireTimeout(httpClientConfig.getConnectionAcquireTimeout());
        fixedConnectionProviderBuilder.maxIdleTime(httpClientConfig.getMaxIdleConnectionTimeout());
        if (httpClientConfig.getHttp2Config().isEnabled()) {
            fixedConnectionProviderBuilder.allocationStrategy((ConnectionProvider.AllocationStrategy)Http2AllocationStrategy.builder().maxConnections(httpClientConfig.getHttp2Config().getMaxConnectionPoolSize()).minConnections(httpClientConfig.getHttp2Config().getMinConnectionPoolSize()).maxConcurrentStreams((long)httpClientConfig.getHttp2Config().getMaxConcurrentStreams()).build());
        }
        return ReactorNettyClient.createWithConnectionProvider(fixedConnectionProviderBuilder.build(), httpClientConfig);
    }

    public static HttpClient create(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        return ReactorNettyClient.create(httpClientConfig);
    }

    public void shutdown();
}

