/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_7_0)
public final class TransactionalBatchOperationResult {
    private final String eTag;
    private final double requestCharge;
    private final ObjectNode resourceObject;
    private final int statusCode;
    private final Duration retryAfter;
    private final int subStatusCode;
    private final CosmosItemOperation cosmosItemOperation;

    TransactionalBatchOperationResult(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, CosmosItemOperation cosmosItemOperation) {
        Preconditions.checkNotNull(statusCode, "expected non-null statusCode");
        Preconditions.checkNotNull(cosmosItemOperation, "expected non-null cosmosItemOperation");
        this.eTag = eTag;
        this.requestCharge = requestCharge;
        this.resourceObject = resourceObject;
        this.statusCode = statusCode;
        this.retryAfter = retryAfter;
        this.subStatusCode = subStatusCode;
        this.cosmosItemOperation = cosmosItemOperation;
    }

    public String getETag() {
        return this.eTag;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public <T> T getItem(Class<T> type) {
        T item = null;
        if (this.getResourceObject() != null) {
            item = new JsonSerializable(this.getResourceObject()).toObject(type);
        }
        return item;
    }

    public Duration getRetryAfterDuration() {
        return this.retryAfter;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public boolean isSuccessStatusCode() {
        return 200 <= this.statusCode && this.statusCode <= 299;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    ObjectNode getResourceObject() {
        return this.resourceObject;
    }

    public CosmosItemOperation getOperation() {
        return this.cosmosItemOperation;
    }
}

