/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GoneException
extends CosmosException {
    public GoneException(String msg) {
        this(msg, null);
    }

    public GoneException() {
        this("The requested resource is no longer available at the server.", null);
    }

    public GoneException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public GoneException(String resourceAddress, CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders, Throwable cause) {
        super(resourceAddress, 410, cosmosError, responseHeaders, cause);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public GoneException(String message, String requestUri) {
        this(message, null, new HashMap<String, String>(), requestUri);
    }

    GoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, new HashMap<String, String>(), null);
    }

    GoneException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUriString);
    }

    public GoneException(String message, HttpHeaders headers, URI requestUrl) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
    }

    public GoneException(String message, HttpHeaders headers, SocketAddress remoteAddress) {
        super(message, null, HttpUtils.asMap(headers), 410, remoteAddress != null ? remoteAddress.toString() : null);
    }

    public GoneException(String message, Exception innerException, HttpHeaders headers, URI requestUrl) {
        super(message, innerException, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
    }

    public GoneException(String message, Exception innerException, Map<String, String> headers, String requestUriString) {
        super(message, innerException, headers, 410, requestUriString);
    }
}

