/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.tracing.Tracer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public class TracerProvider {
    private Tracer tracer;
    public static final String DB_TYPE_VALUE = "Cosmos";
    public static final String DB_TYPE = "db.type";
    public static final String DB_INSTANCE = "db.instance";
    public static final String DB_URL = "db.url";
    public static final String DB_STATEMENT = "db.statement";
    public static final String ERROR_MSG = "error.msg";
    public static final String ERROR_TYPE = "error.type";
    public static final String COSMOS_CALL_DEPTH = "cosmosCallDepth";
    public static final String COSMOS_CALL_DEPTH_VAL = "nested";
    public static final int ERROR_CODE = 0;
    public static final String RESOURCE_PROVIDER_NAME = "Microsoft.DocumentDB";

    public TracerProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    public boolean isEnabled() {
        return this.tracer != null;
    }

    public Context startSpan(String methodName, String databaseId, String endpoint, Context context) {
        Context local = Objects.requireNonNull(context, "'context' cannot be null.");
        local = local.addData((Object)"az.namespace", (Object)RESOURCE_PROVIDER_NAME);
        local = this.tracer.start(methodName, local);
        if (databaseId != null) {
            this.tracer.setAttribute(DB_INSTANCE, databaseId, local);
        }
        this.tracer.setAttribute(DB_TYPE, DB_TYPE_VALUE, local);
        this.tracer.setAttribute(DB_URL, endpoint, local);
        this.tracer.setAttribute(DB_STATEMENT, methodName, local);
        return local;
    }

    public <T extends CosmosResponse<? extends Resource>> void endSpan(Context context, Signal<T> signal, int statusCode) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(signal, "'signal' cannot be null.");
        switch (signal.getType()) {
            case ON_COMPLETE: {
                this.end(statusCode, null, context);
                break;
            }
            case ON_ERROR: {
                Throwable throwable = null;
                if (signal.hasError() && (throwable = signal.getThrowable()) instanceof CosmosException) {
                    CosmosException exception = (CosmosException)((Object)throwable);
                    statusCode = exception.getStatusCode();
                }
                this.end(statusCode, throwable, context);
                break;
            }
        }
    }

    public <T extends CosmosResponse<?>> Mono<T> traceEnabledCosmosResponsePublisher(Mono<T> resultPublisher, Context context, String spanName, String databaseId, String endpoint) {
        return this.traceEnabledPublisher(resultPublisher, context, spanName, databaseId, endpoint, response -> response.getStatusCode());
    }

    public Mono<TransactionalBatchResponse> traceEnabledBatchResponsePublisher(Mono<TransactionalBatchResponse> resultPublisher, Context context, String spanName, String databaseId, String endpoint) {
        return this.traceEnabledPublisher(resultPublisher, context, spanName, databaseId, endpoint, TransactionalBatchResponse::getStatusCode);
    }

    public <T> Mono<CosmosItemResponse<T>> traceEnabledCosmosItemResponsePublisher(Mono<CosmosItemResponse<T>> resultPublisher, Context context, String spanName, String databaseId, String endpoint) {
        return this.traceEnabledPublisher(resultPublisher, context, spanName, databaseId, endpoint, CosmosItemResponse::getStatusCode);
    }

    public <T> Mono<T> traceEnabledPublisher(Mono<T> resultPublisher, Context context, String spanName, String databaseId, String endpoint, Function<T, Integer> statusCodeFunc) {
        AtomicReference<Context> parentContext = new AtomicReference<Context>(Context.NONE);
        Optional callDepth = context.getData((Object)COSMOS_CALL_DEPTH);
        boolean isNestedCall = callDepth.isPresent();
        return resultPublisher.doOnSubscribe(ignoredValue -> {
            if (this.isEnabled() && !isNestedCall) {
                parentContext.set(this.startSpan(spanName, databaseId, endpoint, context));
            }
        }).doOnSuccess(response -> {
            if (this.isEnabled() && !isNestedCall) {
                this.endSpan((Context)parentContext.get(), Signal.complete(), (Integer)statusCodeFunc.apply(response));
            }
        }).doOnError(throwable -> {
            if (this.isEnabled() && !isNestedCall) {
                this.endSpan((Context)parentContext.get(), Signal.error((Throwable)throwable), 0);
            }
        });
    }

    private void end(int statusCode, Throwable throwable, Context context) {
        if (throwable != null) {
            this.tracer.setAttribute(ERROR_MSG, throwable.getMessage(), context);
            this.tracer.setAttribute(ERROR_TYPE, throwable.getClass().getName(), context);
        }
        this.tracer.end(statusCode, throwable, context);
    }
}

