/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.TransactionalBatchOperationResult;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(BatchResponseParser.class);
    private static final char HYBRID_V1 = '\u0081';

    public static TransactionalBatchResponse fromDocumentServiceResponse(RxDocumentServiceResponse documentServiceResponse, ServerBatchRequest request, boolean shouldPromoteOperationStatus) {
        TransactionalBatchResponse response = null;
        byte[] responseContent = documentServiceResponse.getResponseBodyAsByteArray();
        if (responseContent != null && responseContent.length > 0 && (response = BatchResponseParser.populateFromResponseContent(documentServiceResponse, request, shouldPromoteOperationStatus)) == null) {
            response = BridgeInternal.createTransactionBatchResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), 0, "ServerResponseDeserializationFailure", documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        }
        int responseStatusCode = documentServiceResponse.getStatusCode();
        int responseSubStatusCode = BatchExecUtils.getSubStatusCode(documentServiceResponse.getResponseHeaders());
        if (response == null) {
            response = BridgeInternal.createTransactionBatchResponse(responseStatusCode, responseSubStatusCode, null, documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        }
        if (response.size() != request.getOperations().size()) {
            if (responseStatusCode >= 200 && responseStatusCode <= 299) {
                response = BridgeInternal.createTransactionBatchResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), 0, "Invalid server response", documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
            }
            Duration retryAfterDuration = Duration.ZERO;
            if (responseStatusCode == HttpResponseStatus.TOO_MANY_REQUESTS.code()) {
                retryAfterDuration = BatchExecUtils.getRetryAfterDuration(documentServiceResponse.getResponseHeaders());
            }
            BatchResponseParser.createAndPopulateResults(response, request.getOperations(), retryAfterDuration);
        }
        Preconditions.checkState(response.size() == request.getOperations().size(), "Number of responses should be equal to number of operations in request.");
        return response;
    }

    private static TransactionalBatchResponse populateFromResponseContent(RxDocumentServiceResponse documentServiceResponse, ServerBatchRequest request, boolean shouldPromoteOperationStatus) {
        ArrayList<TransactionalBatchOperationResult> results = new ArrayList<TransactionalBatchOperationResult>(request.getOperations().size());
        byte[] responseContent = documentServiceResponse.getResponseBodyAsByteArray();
        if (responseContent[0] != -127) {
            ObjectMapper mapper = Utils.getSimpleObjectMapper();
            try {
                List<CosmosItemOperation> cosmosItemOperations = request.getOperations();
                ObjectNode[] objectNodes = (ObjectNode[])mapper.readValue(responseContent, ObjectNode[].class);
                for (int index = 0; index < objectNodes.length; ++index) {
                    ObjectNode objectInArray = objectNodes[index];
                    results.add(BatchResponseParser.createBatchOperationResultFromJson(objectInArray, cosmosItemOperations.get(index)));
                }
            }
            catch (IOException ex) {
                logger.error("Exception in parsing response", (Throwable)ex);
            }
        } else {
            logger.error("Hybrid row is not implemented right now");
            return null;
        }
        int responseStatusCode = documentServiceResponse.getStatusCode();
        int responseSubStatusCode = BatchExecUtils.getSubStatusCode(documentServiceResponse.getResponseHeaders());
        if (responseStatusCode == HttpResponseStatus.MULTI_STATUS.code() && shouldPromoteOperationStatus) {
            for (TransactionalBatchOperationResult result : results) {
                if (result.getStatusCode() == HttpResponseStatus.FAILED_DEPENDENCY.code() || result.getStatusCode() < 400) continue;
                responseStatusCode = result.getStatusCode();
                responseSubStatusCode = result.getSubStatusCode();
                break;
            }
        }
        TransactionalBatchResponse response = BridgeInternal.createTransactionBatchResponse(responseStatusCode, responseSubStatusCode, null, documentServiceResponse.getResponseHeaders(), documentServiceResponse.getCosmosDiagnostics());
        BridgeInternal.addTransactionBatchResultInResponse(response, results);
        return response;
    }

    private static TransactionalBatchOperationResult createBatchOperationResultFromJson(ObjectNode objectNode, CosmosItemOperation cosmosItemOperation) {
        Double requestCharge;
        JsonSerializable jsonSerializable = new JsonSerializable(objectNode);
        int statusCode = jsonSerializable.getInt("statusCode");
        Integer subStatusCode = jsonSerializable.getInt("subStatusCode");
        if (subStatusCode == null) {
            subStatusCode = 0;
        }
        if ((requestCharge = jsonSerializable.getDouble("requestCharge")) == null) {
            requestCharge = 0.0;
        }
        String eTag = jsonSerializable.getString("eTag");
        ObjectNode resourceBody = jsonSerializable.getObject("resourceBody");
        Integer retryAfterMilliseconds = jsonSerializable.getInt("retryAfterMilliseconds");
        return BridgeInternal.createTransactionBatchResult(eTag, requestCharge, resourceBody, statusCode, retryAfterMilliseconds != null ? Duration.ofMillis(retryAfterMilliseconds.intValue()) : Duration.ZERO, subStatusCode, cosmosItemOperation);
    }

    private static void createAndPopulateResults(TransactionalBatchResponse response, List<CosmosItemOperation> operations, Duration retryAfterDuration) {
        ArrayList<TransactionalBatchOperationResult> results = new ArrayList<TransactionalBatchOperationResult>(operations.size());
        for (CosmosItemOperation cosmosItemOperation : operations) {
            results.add(BridgeInternal.createTransactionBatchResult(null, response.getRequestCharge(), null, response.getStatusCode(), retryAfterDuration, response.getSubStatusCode(), cosmosItemOperation));
        }
        BridgeInternal.addTransactionBatchResultInResponse(response, results);
    }
}

