/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;

public abstract class ServerBatchRequest {
    private final int maxBodyLength;
    private final int maxOperationCount;
    private String requestBody;
    private List<CosmosItemOperation> operations;
    private boolean isAtomicBatch = false;
    private boolean shouldContinueOnError = false;

    ServerBatchRequest(int maxBodyLength, int maxOperationCount) {
        this.maxBodyLength = maxBodyLength;
        this.maxOperationCount = maxOperationCount;
    }

    final List<CosmosItemOperation> createBodyOfBatchRequest(List<CosmosItemOperation> operations) {
        Preconditions.checkNotNull(operations, "expected non-null operations");
        int totalSerializedLength = 0;
        int totalOperationCount = 0;
        ArrayNode arrayNode = Utils.getSimpleObjectMapper().createArrayNode();
        for (CosmosItemOperation operation : operations) {
            if (operation instanceof ItemBatchOperation) {
                ItemBatchOperation itemBatchOperation = (ItemBatchOperation)operation;
                JsonSerializable operationJsonSerializable = itemBatchOperation.serializeOperation();
                int operationSerializedLength = operationJsonSerializable.toString().length();
                if (totalOperationCount != 0 && (totalSerializedLength + operationSerializedLength > this.maxBodyLength || totalOperationCount + 1 > this.maxOperationCount)) break;
                totalSerializedLength += operationSerializedLength;
                ++totalOperationCount;
                arrayNode.add((JsonNode)operationJsonSerializable.getPropertyBag());
                continue;
            }
            throw new UnsupportedOperationException("Unknown CosmosItemOperation.");
        }
        this.requestBody = arrayNode.toString();
        this.operations = operations.subList(0, totalOperationCount);
        return operations.subList(totalOperationCount, operations.size());
    }

    public final String getRequestBody() {
        Preconditions.checkState(this.requestBody != null, "expected non-null body");
        return this.requestBody;
    }

    public final List<CosmosItemOperation> getOperations() {
        return UnmodifiableList.unmodifiableList(this.operations);
    }

    public boolean isAtomicBatch() {
        return this.isAtomicBatch;
    }

    void setAtomicBatch(boolean atomicBatch) {
        this.isAtomicBatch = atomicBatch;
    }

    public boolean isShouldContinueOnError() {
        return this.shouldContinueOnError;
    }

    void setShouldContinueOnError(boolean shouldContinueOnError) {
        this.shouldContinueOnError = shouldContinueOnError;
    }
}

