/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import com.azure.cosmos.implementation.cpu.CpuListener;
import com.azure.cosmos.implementation.cpu.CpuLoad;
import com.azure.cosmos.implementation.cpu.CpuLoadHistory;
import com.azure.cosmos.implementation.cpu.CpuReader;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMonitor {
    private static final int DEFAULT_REFRESH_INTERVAL_IN_SECONDS = 5;
    private static final int HISTORY_LENGTH = 6;
    private static Duration refreshInterval = Duration.ofSeconds(5L);
    private static final Logger logger = LoggerFactory.getLogger(CpuMonitor.class);
    private static final CpuReader cpuReader = new CpuReader();
    private static final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
    private static final ReentrantReadWriteLock rwLock;
    private static final List<WeakReference<CpuListener>> cpuListeners;
    private static final Object lifeCycleLock;
    private static final CpuLoadHistory DEFAULT_READING;
    private static CpuLoadHistory currentReading;
    private static final CpuLoad[] buffer;
    private static ScheduledFuture<?> future;
    private static int clockHand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(CpuListener listener) {
        Object object = lifeCycleLock;
        synchronized (object) {
            if (cpuListeners.size() == 0) {
                CpuMonitor.start();
            }
            cpuListeners.add(new WeakReference<CpuListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(CpuListener listener) {
        Object object = lifeCycleLock;
        synchronized (object) {
            Iterator<WeakReference<CpuListener>> it = cpuListeners.iterator();
            while (it.hasNext()) {
                WeakReference<CpuListener> reference = it.next();
                CpuListener val = (CpuListener)reference.get();
                if (val != null && val != listener) continue;
                it.remove();
            }
            if (cpuListeners.isEmpty()) {
                CpuMonitor.closeInternal();
            }
        }
    }

    public static CpuLoadHistory getCpuLoad() {
        rwLock.readLock().lock();
        try {
            CpuLoadHistory cpuLoadHistory = currentReading;
            return cpuLoadHistory;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeInternal() {
        Object object = lifeCycleLock;
        synchronized (object) {
            if (future != null) {
                future.cancel(false);
                future = null;
            }
            rwLock.writeLock().lock();
            try {
                currentReading = DEFAULT_READING;
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresh() {
        block9: {
            try {
                Instant now = Instant.now();
                float currentUtilization = (float)cpuReader.getSystemWideCpuUsage() * 100.0f;
                if (Float.isNaN(currentUtilization) || !(currentUtilization >= 0.0f)) break block9;
                ArrayList<CpuLoad> cpuLoadHistory = new ArrayList<CpuLoad>(buffer.length);
                CpuLoadHistory newReading = new CpuLoadHistory(cpuLoadHistory, refreshInterval);
                CpuMonitor.buffer[CpuMonitor.clockHand] = new CpuLoad(now, currentUtilization);
                clockHand = (clockHand + 1) % buffer.length;
                for (int i = 0; i < buffer.length; ++i) {
                    int index = (clockHand + i) % buffer.length;
                    if (buffer[index] == null || CpuMonitor.buffer[index].timestamp == null || CpuMonitor.buffer[index].timestamp.equals(Instant.MIN)) continue;
                    cpuLoadHistory.add(buffer[index]);
                }
                Object object = lifeCycleLock;
                synchronized (object) {
                    CpuMonitor.unregister(null);
                }
                rwLock.writeLock().lock();
                try {
                    currentReading = newReading;
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                logger.error("Failed to refresh the cpu history", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        Object object = lifeCycleLock;
        synchronized (object) {
            rwLock.writeLock().lock();
            try {
                currentReading = DEFAULT_READING;
                future = scheduledExecutorService.scheduleAtFixedRate(() -> CpuMonitor.refresh(), 0L, refreshInterval.toMillis() / TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS);
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    static {
        scheduledExecutorService.setRemoveOnCancelPolicy(true);
        rwLock = new ReentrantReadWriteLock();
        cpuListeners = new ArrayList<WeakReference<CpuListener>>();
        lifeCycleLock = new Object();
        currentReading = DEFAULT_READING = new CpuLoadHistory(Collections.emptyList(), refreshInterval);
        buffer = new CpuLoad[6];
        clockHand = 0;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

