/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.TransportException;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.micrometer.core.instrument.Tag;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdTransportClient
extends TransportClient {
    private static final String TAG_NAME = RntbdTransportClient.class.getSimpleName();
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdTransportClient.class);
    private static final String KEY_ON_ERROR_DROPPED = "reactor.onErrorDropped.local";
    private static final Consumer<? super Throwable> onErrorDropHookWithReduceLogLevel = throwable -> {
        if (logger.isDebugEnabled()) {
            logger.debug("Extra error - on error dropped - operator called :", throwable);
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RntbdEndpoint.Provider endpointProvider;
    private final long id;
    private final Tag tag;

    RntbdTransportClient(RntbdEndpoint.Provider endpointProvider) {
        this.endpointProvider = endpointProvider;
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    RntbdTransportClient(Options options, SslContext sslContext) {
        this.endpointProvider = new RntbdServiceEndpoint.Provider(this, options, sslContext);
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug("close {}", (Object)this);
            this.endpointProvider.close();
            return;
        }
        logger.debug("already closed {}", (Object)this);
    }

    public int endpointCount() {
        return this.endpointProvider.count();
    }

    public int endpointEvictionCount() {
        return this.endpointProvider.evictions();
    }

    public long id() {
        return this.id;
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(Uri addressUri, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(addressUri, "expected non-null address");
        Preconditions.checkNotNull(request, "expected non-null request");
        this.throwIfClosed();
        URI address = addressUri.getURI();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, address);
        RntbdEndpoint endpoint = this.endpointProvider.get(address);
        RntbdRequestRecord record = endpoint.request(requestArgs);
        Context reactorContext = Context.of((Object)KEY_ON_ERROR_DROPPED, onErrorDropHookWithReduceLogLevel);
        Mono result = Mono.fromFuture((CompletableFuture)record.whenComplete((response, throwable) -> {
            record.stage(RntbdRequestRecord.Stage.COMPLETED);
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = request.createCosmosDiagnostics();
            }
            if (response != null) {
                RequestTimeline timeline = record.takeTimelineSnapshot();
                response.setRequestTimeline(timeline);
                response.setEndpointStatistics(record.serviceEndpointStatistics());
                response.setRntbdResponseLength(record.responseLength());
                response.setRntbdRequestLength(record.requestLength());
                response.setRequestPayloadLength(request.getContentLength());
                response.setRntbdChannelTaskQueueSize(record.channelTaskQueueLength());
                response.setRntbdPendingRequestSize(record.pendingRequestQueueSize());
            }
        })).onErrorMap(throwable -> {
            Object error;
            Throwable throwable2 = error = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (!(error instanceof CosmosException)) {
                String unexpectedError = RntbdObjectMapper.toJson(error);
                RntbdReporter.reportIssue(logger, endpoint, "request completed with an unexpected {}: \\{\"record\":{},\"error\":{}}", error.getClass(), record, unexpectedError);
                error = new GoneException(Strings.lenientFormat("an unexpected %s occurred: %s", unexpectedError), address.toString());
            }
            assert (error instanceof CosmosException);
            CosmosException cosmosException = (CosmosException)((Object)((Object)error));
            BridgeInternal.setServiceEndpointStatistics(cosmosException, record.serviceEndpointStatistics());
            BridgeInternal.setRntbdRequestLength(cosmosException, record.requestLength());
            BridgeInternal.setRntbdResponseLength(cosmosException, record.responseLength());
            BridgeInternal.setRequestBodyLength(cosmosException, request.getContentLength());
            BridgeInternal.setRequestTimeline(cosmosException, record.takeTimelineSnapshot());
            BridgeInternal.setRntbdPendingRequestQueueSize(cosmosException, record.pendingRequestQueueSize());
            BridgeInternal.setChannelTaskQueueSize(cosmosException, record.channelTaskQueueLength());
            BridgeInternal.setSendingRequestStarted(cosmosException, record.hasSendingRequestStarted());
            return cosmosException;
        });
        return result.doFinally(signalType -> {
            if (signalType != SignalType.CANCEL) {
                return;
            }
            result.subscribe(response -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("received response to cancelled request: {\"request\":{},\"response\":{\"type\":{},\"value\":{}}}}", new Object[]{RntbdObjectMapper.toJson(record), response.getClass().getSimpleName(), RntbdObjectMapper.toJson(response)});
                }
            }, throwable -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("received response to cancelled request: {\"request\":{},\"response\":{\"type\":{},\"value\":{}}}", new Object[]{RntbdObjectMapper.toJson(record), throwable.getClass().getSimpleName(), RntbdObjectMapper.toJson(throwable)});
                }
            });
        }).subscriberContext(reactorContext);
    }

    public Tag tag() {
        return this.tag;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private static Tag tag(long id) {
        return Tag.of((String)TAG_NAME, (String)com.azure.cosmos.implementation.guava25.base.Strings.padStart(Long.toHexString(id).toUpperCase(Locale.ROOT), 4, '0'));
    }

    private void throwIfClosed() {
        if (this.closed.get()) {
            throw new TransportException(Strings.lenientFormat("%s is closed", this), null);
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdTransportClient> {
        private static final long serialVersionUID = 1007663695768825670L;

        JsonSerializer() {
            super(RntbdTransportClient.class);
        }

        public void serialize(RntbdTransportClient value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("id", value.id());
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectField("configuration", (Object)value.endpointProvider.config());
            generator.writeObjectFieldStart("serviceEndpoints");
            generator.writeNumberField("count", value.endpointCount());
            generator.writeArrayFieldStart("items");
            Iterator iterator = value.endpointProvider.list().iterator();
            while (iterator.hasNext()) {
                generator.writeObject(iterator.next());
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    public static final class Options {
        private static final int DEFAULT_MIN_MAX_CONCURRENT_REQUESTS_PER_ENDPOINT = 10000;
        @JsonProperty
        private final int bufferPageSize;
        @JsonProperty
        private final Duration connectionAcquisitionTimeout;
        @JsonProperty
        private final Duration connectTimeout;
        @JsonProperty
        private final Duration idleChannelTimeout;
        @JsonProperty
        private final Duration idleChannelTimerResolution;
        @JsonProperty
        private final Duration idleEndpointTimeout;
        @JsonProperty
        private final int maxBufferCapacity;
        @JsonProperty
        private final int maxChannelsPerEndpoint;
        @JsonProperty
        private final int maxRequestsPerChannel;
        @JsonProperty
        private final int maxConcurrentRequestsPerEndpointOverride;
        @JsonProperty
        private final Duration receiveHangDetectionTime;
        @JsonProperty
        private final Duration requestExpiryInterval;
        @JsonProperty
        private final Duration requestTimeout;
        @JsonProperty
        private final Duration requestTimerResolution;
        @JsonProperty
        private final Duration sendHangDetectionTime;
        @JsonProperty
        private final Duration shutdownTimeout;
        @JsonProperty
        private final int threadCount;
        @JsonIgnore
        private final UserAgentContainer userAgent;

        @JsonCreator
        private Options() {
            this(ConnectionPolicy.getDefaultPolicy());
        }

        private Options(Builder builder) {
            this.bufferPageSize = builder.bufferPageSize;
            this.connectionAcquisitionTimeout = builder.connectionAcquisitionTimeout;
            this.idleChannelTimeout = builder.idleChannelTimeout;
            this.idleChannelTimerResolution = builder.idleChannelTimerResolution;
            this.idleEndpointTimeout = builder.idleEndpointTimeout;
            this.maxBufferCapacity = builder.maxBufferCapacity;
            this.maxChannelsPerEndpoint = builder.maxChannelsPerEndpoint;
            this.maxRequestsPerChannel = builder.maxRequestsPerChannel;
            this.maxConcurrentRequestsPerEndpointOverride = builder.maxConcurrentRequestsPerEndpointOverride;
            this.receiveHangDetectionTime = builder.receiveHangDetectionTime;
            this.requestExpiryInterval = builder.requestExpiryInterval;
            this.requestTimeout = builder.requestTimeout;
            this.requestTimerResolution = builder.requestTimerResolution;
            this.sendHangDetectionTime = builder.sendHangDetectionTime;
            this.shutdownTimeout = builder.shutdownTimeout;
            this.threadCount = builder.threadCount;
            this.userAgent = builder.userAgent;
            this.connectTimeout = builder.connectTimeout == null ? builder.requestTimeout : builder.connectTimeout;
        }

        private Options(ConnectionPolicy connectionPolicy) {
            this.bufferPageSize = 8192;
            this.connectionAcquisitionTimeout = Duration.ofSeconds(5L);
            this.connectTimeout = connectionPolicy.getConnectTimeout();
            this.idleChannelTimeout = connectionPolicy.getIdleTcpConnectionTimeout();
            this.idleChannelTimerResolution = Duration.ofMillis(100L);
            this.idleEndpointTimeout = connectionPolicy.getIdleEndpointTimeout();
            this.maxBufferCapacity = 0x800000;
            this.maxChannelsPerEndpoint = connectionPolicy.getMaxConnectionsPerEndpoint();
            this.maxRequestsPerChannel = connectionPolicy.getMaxRequestsPerConnection();
            this.maxConcurrentRequestsPerEndpointOverride = -1;
            this.receiveHangDetectionTime = Duration.ofSeconds(65L);
            this.requestExpiryInterval = Duration.ofSeconds(5L);
            this.requestTimeout = connectionPolicy.getRequestTimeout();
            this.requestTimerResolution = Duration.ofMillis(100L);
            this.sendHangDetectionTime = Duration.ofSeconds(10L);
            this.shutdownTimeout = Duration.ofSeconds(15L);
            this.threadCount = 2 * Runtime.getRuntime().availableProcessors();
            this.userAgent = new UserAgentContainer();
        }

        public int bufferPageSize() {
            return this.bufferPageSize;
        }

        public Duration connectionAcquisitionTimeout() {
            return this.connectionAcquisitionTimeout;
        }

        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        public Duration idleChannelTimeout() {
            return this.idleChannelTimeout;
        }

        public Duration idleChannelTimerResolution() {
            return this.idleChannelTimerResolution;
        }

        public Duration idleEndpointTimeout() {
            return this.idleEndpointTimeout;
        }

        public int maxBufferCapacity() {
            return this.maxBufferCapacity;
        }

        public int maxChannelsPerEndpoint() {
            return this.maxChannelsPerEndpoint;
        }

        public int maxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public int maxConcurrentRequestsPerEndpoint() {
            if (this.maxConcurrentRequestsPerEndpointOverride > 0) {
                return this.maxConcurrentRequestsPerEndpointOverride;
            }
            return Math.max(10000, this.maxChannelsPerEndpoint * this.maxRequestsPerChannel);
        }

        public Duration receiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public Duration requestTimeout() {
            return this.requestTimeout;
        }

        public Duration requestTimerResolution() {
            return this.requestTimerResolution;
        }

        public Duration sendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public Duration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public int threadCount() {
            return this.threadCount;
        }

        public UserAgentContainer userAgent() {
            return this.userAgent;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }

        static /* synthetic */ int access$2000(Options x0) {
            return x0.bufferPageSize;
        }

        static /* synthetic */ Duration access$2100(Options x0) {
            return x0.connectionAcquisitionTimeout;
        }

        public static class Builder {
            private static final String DEFAULT_OPTIONS_PROPERTY_NAME = "azure.cosmos.directTcp.defaultOptions";
            private static final Options DEFAULT_OPTIONS;
            private int bufferPageSize = Options.access$2000(DEFAULT_OPTIONS);
            private final Duration connectionAcquisitionTimeout = Options.access$2100(DEFAULT_OPTIONS);
            private Duration connectTimeout;
            private Duration idleChannelTimeout;
            private Duration idleChannelTimerResolution;
            private Duration idleEndpointTimeout;
            private int maxBufferCapacity;
            private int maxChannelsPerEndpoint;
            private int maxRequestsPerChannel;
            private int maxConcurrentRequestsPerEndpointOverride;
            private Duration receiveHangDetectionTime;
            private Duration requestExpiryInterval;
            private Duration requestTimeout;
            private Duration requestTimerResolution;
            private Duration sendHangDetectionTime;
            private Duration shutdownTimeout;
            private int threadCount;
            private UserAgentContainer userAgent;

            public Builder(ConnectionPolicy connectionPolicy) {
                this.connectTimeout = connectionPolicy.getConnectTimeout();
                this.idleChannelTimeout = connectionPolicy.getIdleTcpConnectionTimeout();
                this.idleChannelTimerResolution = DEFAULT_OPTIONS.idleChannelTimerResolution;
                this.idleEndpointTimeout = DEFAULT_OPTIONS.idleEndpointTimeout;
                this.maxBufferCapacity = DEFAULT_OPTIONS.maxBufferCapacity;
                this.maxChannelsPerEndpoint = connectionPolicy.getMaxConnectionsPerEndpoint();
                this.maxRequestsPerChannel = connectionPolicy.getMaxRequestsPerConnection();
                this.maxConcurrentRequestsPerEndpointOverride = DEFAULT_OPTIONS.maxConcurrentRequestsPerEndpointOverride;
                this.receiveHangDetectionTime = DEFAULT_OPTIONS.receiveHangDetectionTime;
                this.requestExpiryInterval = DEFAULT_OPTIONS.requestExpiryInterval;
                this.requestTimeout = connectionPolicy.getRequestTimeout();
                this.requestTimerResolution = DEFAULT_OPTIONS.requestTimerResolution;
                this.sendHangDetectionTime = DEFAULT_OPTIONS.sendHangDetectionTime;
                this.shutdownTimeout = DEFAULT_OPTIONS.shutdownTimeout;
                this.threadCount = DEFAULT_OPTIONS.threadCount;
                this.userAgent = DEFAULT_OPTIONS.userAgent;
            }

            public Builder bufferPageSize(int value) {
                Preconditions.checkArgument(value >= 4096 && (value & value - 1) == 0, "expected value to be a power of 2 >= 4096, not %s", value);
                this.bufferPageSize = value;
                return this;
            }

            public Options build() {
                Preconditions.checkState(this.bufferPageSize <= this.maxBufferCapacity, "expected bufferPageSize (%s) <= maxBufferCapacity (%s)", this.bufferPageSize, this.maxBufferCapacity);
                return new Options(this);
            }

            public Builder connectionAcquisitionTimeout(Duration value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.connectTimeout = value.compareTo(Duration.ZERO) < 0 ? Duration.ZERO : value;
                return this;
            }

            public Builder connectionTimeout(Duration value) {
                Preconditions.checkArgument(value == null || value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.connectTimeout = value;
                return this;
            }

            public Builder idleChannelTimeout(Duration value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.idleChannelTimeout = value;
                return this;
            }

            public Builder idleChannelTimerResolution(Duration value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.idleChannelTimerResolution = value;
                return this;
            }

            public Builder idleEndpointTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.idleEndpointTimeout = value;
                return this;
            }

            public Builder maxBufferCapacity(int value) {
                Preconditions.checkArgument(value > 0 && (value & value - 1) == 0, "expected positive value, not %s", value);
                this.maxBufferCapacity = value;
                return this;
            }

            public Builder maxChannelsPerEndpoint(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxChannelsPerEndpoint = value;
                return this;
            }

            public Builder maxRequestsPerChannel(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxRequestsPerChannel = value;
                return this;
            }

            public Builder maxConcurrentRequestsPerEndpointOverride(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxConcurrentRequestsPerEndpointOverride = value;
                return this;
            }

            public Builder receiveHangDetectionTime(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.receiveHangDetectionTime = value;
                return this;
            }

            public Builder requestExpiryInterval(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.requestExpiryInterval = value;
                return this;
            }

            public Builder requestTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.requestTimeout = value;
                return this;
            }

            public Builder requestTimerResolution(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.requestTimerResolution = value;
                return this;
            }

            public Builder sendHangDetectionTime(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.sendHangDetectionTime = value;
                return this;
            }

            public Builder shutdownTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.shutdownTimeout = value;
                return this;
            }

            public Builder threadCount(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.threadCount = value;
                return this;
            }

            public Builder userAgent(UserAgentContainer value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.userAgent = value;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static {
                Options options;
                block21: {
                    options = null;
                    try {
                        String path;
                        String string = System.getProperty(DEFAULT_OPTIONS_PROPERTY_NAME);
                        if (string != null) {
                            try {
                                options = RntbdObjectMapper.readValue(string, Options.class);
                            }
                            catch (IOException error) {
                                logger.error("failed to parse default Direct TCP options {} due to ", (Object)string, (Object)error);
                            }
                        }
                        if (options == null && (path = System.getProperty("azure.cosmos.directTcp.defaultOptionsFile")) != null) {
                            try {
                                options = RntbdObjectMapper.readValue(new File(path), Options.class);
                            }
                            catch (IOException error) {
                                logger.error("failed to load default Direct TCP options from {} due to ", (Object)path, (Object)error);
                            }
                        }
                        if (options == null) {
                            ClassLoader loader = RntbdTransportClient.class.getClassLoader();
                            String name = "azure.cosmos.directTcp.defaultOptions.json";
                            try (InputStream stream = loader.getResourceAsStream("azure.cosmos.directTcp.defaultOptions.json");){
                                if (stream != null) {
                                    options = RntbdObjectMapper.readValue(stream, Options.class);
                                }
                            }
                            catch (IOException error) {
                                logger.error("failed to load Direct TCP options from resource {} due to ", (Object)"azure.cosmos.directTcp.defaultOptions.json", (Object)error);
                            }
                        }
                        if (options != null) break block21;
                        DEFAULT_OPTIONS = new Options(ConnectionPolicy.getDefaultPolicy());
                    }
                    catch (Throwable throwable) {
                        if (options == null) {
                            DEFAULT_OPTIONS = new Options(ConnectionPolicy.getDefaultPolicy());
                        } else {
                            logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, options);
                            DEFAULT_OPTIONS = options;
                        }
                        throw throwable;
                    }
                }
                logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, (Object)options);
                DEFAULT_OPTIONS = options;
            }
        }
    }
}

