/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosItemOperationType;
import com.azure.cosmos.TransactionalBatchItemRequestOptions;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;
import java.util.ArrayList;
import java.util.List;

@Beta(value=Beta.SinceVersion.V4_7_0)
public final class TransactionalBatch {
    private final List<ItemBatchOperation<?>> operations;
    private final PartitionKey partitionKey;

    TransactionalBatch(PartitionKey partitionKey) {
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        this.operations = new ArrayList();
        this.partitionKey = partitionKey;
    }

    public static TransactionalBatch createTransactionalBatch(PartitionKey partitionKey) {
        return new TransactionalBatch(partitionKey);
    }

    public <T> CosmosItemOperation createItemOperation(T item) {
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.createItemOperation(item, new TransactionalBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation createItemOperation(T item, TransactionalBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.CREATE, null, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public CosmosItemOperation deleteItemOperation(String id) {
        Preconditions.checkNotNull(id, "expected non-null id");
        return this.deleteItemOperation(id, new TransactionalBatchItemRequestOptions());
    }

    public CosmosItemOperation deleteItemOperation(String id, TransactionalBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchItemRequestOptions();
        }
        ItemBatchOperation<Object> operation = new ItemBatchOperation<Object>(CosmosItemOperationType.DELETE, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), null);
        this.operations.add(operation);
        return operation;
    }

    public CosmosItemOperation readItemOperation(String id) {
        Preconditions.checkNotNull(id, "expected non-null id");
        return this.readItemOperation(id, new TransactionalBatchItemRequestOptions());
    }

    public CosmosItemOperation readItemOperation(String id, TransactionalBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchItemRequestOptions();
        }
        ItemBatchOperation<Object> operation = new ItemBatchOperation<Object>(CosmosItemOperationType.READ, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), null);
        this.operations.add(operation);
        return operation;
    }

    public <T> CosmosItemOperation replaceItemOperation(String id, T item) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.replaceItemOperation(id, item, new TransactionalBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation replaceItemOperation(String id, T item, TransactionalBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.REPLACE, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public <T> CosmosItemOperation upsertItemOperation(T item) {
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.upsertItemOperation(item, new TransactionalBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation upsertItemOperation(T item, TransactionalBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.UPSERT, null, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public List<CosmosItemOperation> getOperations() {
        return UnmodifiableList.unmodifiableList(this.operations);
    }

    public PartitionKey getPartitionKeyValue() {
        return this.partitionKey;
    }
}

