/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.metrics.QueryMetricsTextWriter;
import java.time.Duration;
import java.util.Map;

public final class FeedResponseDiagnostics {
    private static final String EQUALS = "=";
    private static final String QUERY_PLAN = "QueryPlan";
    private static final String SPACE = " ";
    private Map<String, QueryMetrics> queryMetricsMap;
    private QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext;

    public FeedResponseDiagnostics(Map<String, QueryMetrics> queryMetricsMap) {
        this.queryMetricsMap = queryMetricsMap;
    }

    Map<String, QueryMetrics> getQueryMetricsMap() {
        return this.queryMetricsMap;
    }

    FeedResponseDiagnostics setQueryMetricsMap(Map<String, QueryMetrics> queryMetricsMap) {
        this.queryMetricsMap = queryMetricsMap;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.diagnosticsContext != null) {
            stringBuilder.append("QueryPlan Start Time (UTC)").append(EQUALS).append(QueryMetricsTextWriter.DATE_TIME_FORMATTER.format(this.diagnosticsContext.getStartTimeUTC())).append(System.lineSeparator());
            stringBuilder.append("QueryPlan End Time (UTC)").append(EQUALS).append(QueryMetricsTextWriter.DATE_TIME_FORMATTER.format(this.diagnosticsContext.getEndTimeUTC())).append(System.lineSeparator());
            if (this.diagnosticsContext.getStartTimeUTC() != null && this.diagnosticsContext.getEndTimeUTC() != null) {
                stringBuilder.append("QueryPlan Duration (ms)").append(EQUALS).append(Duration.between(this.diagnosticsContext.getStartTimeUTC(), this.diagnosticsContext.getEndTimeUTC()).toMillis()).append(System.lineSeparator());
            }
        }
        if (this.queryMetricsMap != null && !this.queryMetricsMap.isEmpty()) {
            this.queryMetricsMap.forEach((key, value) -> stringBuilder.append((String)key).append(EQUALS).append(value.toString()).append(System.lineSeparator()));
        }
        return stringBuilder.toString();
    }

    public void setDiagnosticsContext(QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext) {
        this.diagnosticsContext = diagnosticsContext;
    }
}

