/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PermissionMode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Locale;

public final class Permission
extends Resource {
    public Permission() {
    }

    public Permission(String jsonString) {
        super(jsonString);
    }

    @Override
    public Permission setId(String id) {
        super.setId(id);
        return this;
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public void setResourceLink(String resourceLink) {
        BridgeInternal.setProperty(this, "resource", resourceLink);
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase(value));
    }

    public void setPermissionMode(PermissionMode permissionMode) {
        BridgeInternal.setProperty(this, "permissionMode", permissionMode.toString().toLowerCase(Locale.ROOT));
    }

    public String getToken() {
        return super.getString("_token");
    }

    public PartitionKey getResourcePartitionKey() {
        PartitionKey key = null;
        Object value = super.get("resourcePartitionKey");
        if (value != null) {
            ArrayNode arrayValue = (ArrayNode)value;
            key = new PartitionKey(BridgeInternal.getValue(arrayValue.get(0)));
        }
        return key;
    }

    public void setResourcePartitionKey(PartitionKey partitionkey) {
        BridgeInternal.setProperty(this, "resourcePartitionKey", BridgeInternal.getPartitionKeyInternal(partitionkey).toJson());
    }
}

