/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.implementation.caches.AsyncLazy;
import com.azure.cosmos.implementation.caches.IEqualityComparer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncCache<TKey, TValue> {
    private final Logger logger = LoggerFactory.getLogger(AsyncCache.class);
    private final ConcurrentHashMap<TKey, AsyncLazy<TValue>> values = new ConcurrentHashMap();
    private final IEqualityComparer<TValue> equalityComparer;

    public AsyncCache(IEqualityComparer<TValue> equalityComparer) {
        this.equalityComparer = equalityComparer;
    }

    public AsyncCache() {
        this((value1, value2) -> {
            if (value1 == value2) {
                return true;
            }
            if (value1 == null || value2 == null) {
                return false;
            }
            return value1.equals(value2);
        });
    }

    public void set(TKey key, TValue value) {
        this.logger.debug("set cache[{}]={}", key, value);
        this.values.put(key, new AsyncLazy<TValue>(value));
    }

    public Mono<TValue> getAsync(TKey key, TValue obsoleteValue, Callable<Mono<TValue>> singleValueInitFunc) {
        AsyncLazy initialLazyValue = this.values.get(key);
        if (initialLazyValue != null) {
            this.logger.debug("cache[{}] exists", key);
            return initialLazyValue.single().flux().flatMap(value -> {
                if (!this.equalityComparer.areEqual(value, obsoleteValue)) {
                    this.logger.debug("Returning cache[{}] as it is different from obsoleteValue", key);
                    return Flux.just((Object)value);
                }
                this.logger.debug("cache[{}] result value is obsolete ({}), computing new value", key, obsoleteValue);
                AsyncLazy<Callable> asyncLazy = new AsyncLazy<Callable>(singleValueInitFunc);
                AsyncLazy actualValue = this.values.merge(key, asyncLazy, (lazyValue1, lazyValue2) -> lazyValue1 == initialLazyValue ? lazyValue2 : lazyValue1);
                return actualValue.single().flux();
            }, err -> {
                this.logger.debug("cache[{}] resulted in error, computing new value", key, err);
                AsyncLazy<Callable> asyncLazy = new AsyncLazy<Callable>(singleValueInitFunc);
                AsyncLazy resultAsyncLazy = this.values.merge(key, asyncLazy, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
                return resultAsyncLazy.single().flux();
            }, Flux::empty).single();
        }
        this.logger.debug("cache[{}] doesn't exist, computing new value", key);
        AsyncLazy<Callable<Mono<TValue>>> asyncLazy = new AsyncLazy<Callable<Mono<TValue>>>(singleValueInitFunc);
        AsyncLazy resultAsyncLazy = this.values.merge(key, asyncLazy, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
        return resultAsyncLazy.single();
    }

    public void remove(TKey key) {
        this.values.remove(key);
    }

    public Mono<TValue> removeAsync(TKey key) {
        AsyncLazy<TValue> lazy = this.values.remove(key);
        return lazy.single();
    }

    public void clear() {
        this.values.clear();
    }

    public void refresh(TKey key, Callable<Mono<TValue>> singleValueInitFunc) {
        this.logger.debug("refreshing cache[{}]", key);
        AsyncLazy initialLazyValue = this.values.get(key);
        if (initialLazyValue != null && (initialLazyValue.isSucceeded() || initialLazyValue.isFaulted())) {
            AsyncLazy<Callable<Mono<TValue>>> newLazyValue = new AsyncLazy<Callable<Mono<TValue>>>(singleValueInitFunc);
            this.values.merge(key, newLazyValue, (lazyValue1, lazyValu2) -> lazyValue1 == initialLazyValue ? lazyValu2 : lazyValue1);
        }
    }
}

