/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.LeaseContainer;
import com.azure.cosmos.implementation.changefeed.RemainingPartitionWork;
import com.azure.cosmos.implementation.changefeed.RemainingWorkEstimator;
import java.util.Iterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RemainingWorkEstimatorImpl
implements RemainingWorkEstimator {
    private static final char PKRangeIdSeparator = ':';
    private static final char SegmentSeparator = '#';
    private static final String LSNPropertyName = "_lsn";
    private final ChangeFeedContextClient feedDocumentClient;
    private final LeaseContainer leaseContainer;
    private final String collectionSelfLink;
    private final int degreeOfParallelism;

    public RemainingWorkEstimatorImpl(LeaseContainer leaseContainer, ChangeFeedContextClient feedDocumentClient, String collectionSelfLink, int degreeOfParallelism) {
        if (leaseContainer == null) {
            throw new IllegalArgumentException("leaseContainer");
        }
        if (collectionSelfLink == null || collectionSelfLink.isEmpty()) {
            throw new IllegalArgumentException("collectionSelfLink");
        }
        if (feedDocumentClient == null) {
            throw new IllegalArgumentException("feedDocumentClient");
        }
        if (degreeOfParallelism < 1) {
            throw new IllegalArgumentException("degreeOfParallelism - Degree of parallelism is out of range");
        }
        this.leaseContainer = leaseContainer;
        this.collectionSelfLink = collectionSelfLink;
        this.feedDocumentClient = feedDocumentClient;
        this.degreeOfParallelism = degreeOfParallelism;
    }

    @Override
    public Mono<Long> estimatedRemainingWork() {
        return this.estimatedRemainingWorkPerPartition().map(RemainingPartitionWork::getRemainingWork).collectList().map(list -> {
            long sum;
            if (list.size() == 0) {
                sum = 1L;
            } else {
                sum = 0L;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long value = (Long)iterator.next();
                    sum += value;
                }
            }
            return sum;
        });
    }

    @Override
    public Flux<RemainingPartitionWork> estimatedRemainingWorkPerPartition() {
        return null;
    }
}

