/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import com.azure.cosmos.implementation.Utils;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuReader {
    private static final Logger logger = LoggerFactory.getLogger(CpuReader.class);
    private final OperatingSystemMXBean operatingSystemMXBean;

    public CpuReader() {
        java.lang.management.OperatingSystemMXBean mxBean = null;
        try {
            mxBean = ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Throwable t) {
            logger.error("failed to initialized CpuReader", t);
        }
        this.operatingSystemMXBean = this.tryGetAs(mxBean, OperatingSystemMXBean.class);
    }

    public double getSystemWideCpuUsage() {
        try {
            double val;
            if (this.operatingSystemMXBean != null && (val = this.operatingSystemMXBean.getSystemCpuLoad()) > 0.0) {
                return val;
            }
            return Double.NaN;
        }
        catch (Throwable t) {
            logger.error("Failed to get System CPU", t);
            return Double.NaN;
        }
    }

    private <T> T tryGetAs(java.lang.management.OperatingSystemMXBean mxBean, Class<T> classType) {
        try {
            return Utils.as(mxBean, classType);
        }
        catch (Throwable t) {
            logger.error("failed to initialized CpuReader as type {}", (Object)classType.getName(), (Object)t);
            return null;
        }
    }
}

