/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.IndexingDirective;
import com.azure.cosmos.models.PartitionKey;
import java.util.ArrayList;
import java.util.List;

public class CosmosItemRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private IndexingDirective indexingDirective;
    private List<String> preTriggerInclude;
    private List<String> postTriggerInclude;
    private String sessionToken;
    private PartitionKey partitionKey;
    private String ifMatchETag;
    private String ifNoneMatchETag;

    CosmosItemRequestOptions(CosmosItemRequestOptions options) {
        this.consistencyLevel = options.consistencyLevel;
        this.indexingDirective = options.indexingDirective;
        this.preTriggerInclude = options.preTriggerInclude != null ? new ArrayList<String>(options.preTriggerInclude) : null;
        this.postTriggerInclude = options.postTriggerInclude != null ? new ArrayList<String>(options.postTriggerInclude) : null;
        this.sessionToken = options.sessionToken;
        this.partitionKey = options.partitionKey;
        this.ifMatchETag = options.ifMatchETag;
        this.ifNoneMatchETag = options.ifNoneMatchETag;
    }

    public CosmosItemRequestOptions() {
    }

    CosmosItemRequestOptions(PartitionKey partitionKey) {
        this.setPartitionKey(partitionKey);
    }

    public String getIfMatchETag() {
        return this.ifMatchETag;
    }

    public CosmosItemRequestOptions setIfMatchETag(String ifMatchETag) {
        this.ifMatchETag = ifMatchETag;
        return this;
    }

    public String getIfNoneMatchETag() {
        return this.ifNoneMatchETag;
    }

    public CosmosItemRequestOptions setIfNoneMatchETag(String ifNoneMatchETag) {
        this.ifNoneMatchETag = ifNoneMatchETag;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosItemRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public IndexingDirective getIndexingDirective() {
        return this.indexingDirective;
    }

    public CosmosItemRequestOptions setIndexingDirective(IndexingDirective indexingDirective) {
        this.indexingDirective = indexingDirective;
        return this;
    }

    public List<String> getPreTriggerInclude() {
        return this.preTriggerInclude;
    }

    public CosmosItemRequestOptions setPreTriggerInclude(List<String> preTriggerInclude) {
        this.preTriggerInclude = preTriggerInclude;
        return this;
    }

    public List<String> getPostTriggerInclude() {
        return this.postTriggerInclude;
    }

    public CosmosItemRequestOptions setPostTriggerInclude(List<String> postTriggerInclude) {
        this.postTriggerInclude = postTriggerInclude;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosItemRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    CosmosItemRequestOptions setPartitionKey(PartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setIfMatchETag(this.getIfMatchETag());
        requestOptions.setIfNoneMatchETag(this.getIfNoneMatchETag());
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setIndexingDirective(this.indexingDirective);
        requestOptions.setPreTriggerInclude(this.preTriggerInclude);
        requestOptions.setPostTriggerInclude(this.postTriggerInclude);
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setPartitionKey(this.partitionKey);
        return requestOptions;
    }
}

