/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenConnectionAndInitCachesRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(OpenConnectionAndInitCachesRetryPolicy.class);
    private static final int MAX_ADDRESS_RETRY_COUNT = 2;
    private final AtomicInteger queryPlanAddressRefreshCount;
    private final ResourceThrottleRetryPolicy resourceThrottleRetryPolicy;

    public OpenConnectionAndInitCachesRetryPolicy(ThrottlingRetryOptions throttlingRetryOptions) {
        Preconditions.checkNotNull(throttlingRetryOptions, "Argument 'throttlingRetryOptions' should not be null");
        this.queryPlanAddressRefreshCount = new AtomicInteger(0);
        this.resourceThrottleRetryPolicy = new ResourceThrottleRetryPolicy(throttlingRetryOptions.getMaxRetryAttemptsOnThrottledRequests(), throttlingRetryOptions.getMaxRetryWaitTime(), false);
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        CosmosException clientException;
        if (WebExceptionUtility.isNetworkFailure(e) && (clientException = Utils.as(e, CosmosException.class)) != null && WebExceptionUtility.isReadTimeoutException((Exception)((Object)clientException)) && Exceptions.isSubStatusCode(clientException, 10002)) {
            if (this.queryPlanAddressRefreshCount.getAndIncrement() > 2) {
                logger.warn("Received exception after exhausting all retries.", (Throwable)e);
                return Mono.just((Object)ShouldRetryResult.NO_RETRY);
            }
            return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ZERO));
        }
        return this.resourceThrottleRetryPolicy.shouldRetry(e);
    }

    @Override
    public RetryContext getRetryContext() {
        return null;
    }
}

