/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBulkItemRequestOptions;
import com.azure.cosmos.models.CosmosBulkPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.PartitionKey;

public final class CosmosBulkOperations {
    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getCreateItemOperation(item, partitionKey, new CosmosBulkItemRequestOptions(), null);
    }

    public static <T, TContext> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getCreateItemOperation(item, partitionKey, new CosmosBulkItemRequestOptions(), context);
    }

    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getCreateItemOperation(item, partitionKey, requestOptions, null);
    }

    public static <T, TContext> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.CREATE, null, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getDeleteItemOperation(id, partitionKey, new CosmosBulkItemRequestOptions());
    }

    public static <TContext> CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getDeleteItemOperation(id, partitionKey, new CosmosBulkItemRequestOptions(), context);
    }

    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return CosmosBulkOperations.getDeleteItemOperation(id, partitionKey, requestOptions, null);
    }

    public static <TContext> CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object, TContext>(CosmosItemOperationType.DELETE, id, partitionKey, requestOptions.toRequestOptions(), null, context);
    }

    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReadItemOperation(id, partitionKey, new CosmosBulkItemRequestOptions(), null);
    }

    public static <TContext> CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReadItemOperation(id, partitionKey, new CosmosBulkItemRequestOptions(), context);
    }

    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReadItemOperation(id, partitionKey, requestOptions, null);
    }

    public static <TContext> CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object, TContext>(CosmosItemOperationType.READ, id, partitionKey, requestOptions.toRequestOptions(), null, context);
    }

    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReplaceItemOperation(id, item, partitionKey, new CosmosBulkItemRequestOptions(), null);
    }

    public static <T, TContext> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReplaceItemOperation(id, item, partitionKey, new CosmosBulkItemRequestOptions(), context);
    }

    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getReplaceItemOperation(id, item, partitionKey, requestOptions, null);
    }

    public static <T, TContext> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.REPLACE, id, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getUpsertItemOperation(item, partitionKey, new CosmosBulkItemRequestOptions(), null);
    }

    public static <T, TContext> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getUpsertItemOperation(item, partitionKey, new CosmosBulkItemRequestOptions(), context);
    }

    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return CosmosBulkOperations.getUpsertItemOperation(item, partitionKey, requestOptions, null);
    }

    public static <T, TContext> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, CosmosBulkItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkItemRequestOptions();
        }
        return new ItemBulkOperation<T, TContext>(CosmosItemOperationType.UPSERT, null, partitionKey, requestOptions.toRequestOptions(), item, context);
    }

    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return CosmosBulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, new CosmosBulkPatchItemRequestOptions(), null);
    }

    public static <TContext> CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return CosmosBulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, new CosmosBulkPatchItemRequestOptions(), context);
    }

    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosBulkPatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return CosmosBulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, requestOptions, null);
    }

    public static <TContext> CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosBulkPatchItemRequestOptions requestOptions, TContext context) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (requestOptions == null) {
            requestOptions = new CosmosBulkPatchItemRequestOptions();
        }
        return new ItemBulkOperation<CosmosPatchOperations, TContext>(CosmosItemOperationType.PATCH, id, partitionKey, requestOptions.toRequestOptions(), cosmosPatchOperations, context);
    }
}

