/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.util;

import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.util.CosmosPagedFluxStaticListImpl;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public class CosmosPagedFlux<T>
extends ContinuablePagedFlux<String, T, FeedResponse<T>> {
    CosmosPagedFlux() {
    }

    public Flux<FeedResponse<T>> byPage() {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken) {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    public Flux<FeedResponse<T>> byPage(int preferredPageSize) {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    public Flux<FeedResponse<T>> byPage(String continuationToken, int preferredPageSize) {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    public CosmosPagedFlux<T> handle(Consumer<FeedResponse<T>> newFeedResponseConsumer) {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    CosmosPagedFlux<T> withDefaultPageSize(int pageSize) {
        throw new UnsupportedOperationException("Has to be overridden in child classes.");
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        Flux<FeedResponse<T>> pagedResponse = this.byPage();
        pagedResponse.flatMap(tFeedResponse -> {
            IterableStream elements = tFeedResponse.getElements();
            if (elements == null) {
                return Flux.empty();
            }
            return Flux.fromIterable(elements);
        }).subscribe(coreSubscriber);
    }

    public static <T> CosmosPagedFlux<T> fromList(List<T> items, boolean isChangeFeed) {
        return new CosmosPagedFluxStaticListImpl<T>(items, isChangeFeed);
    }
}

