/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.directconnectivity.ResponseUtils;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.http.HttpResponse;
import reactor.core.publisher.Mono;

public class HttpClientUtils {
    static Mono<RxDocumentServiceResponse> parseResponseAsync(String endpoint, RxDocumentServiceRequest request, DiagnosticsClientContext diagnosticsClientContext, Mono<HttpResponse> httpResponse) {
        return httpResponse.flatMap(response -> {
            if (response.statusCode() < 400) {
                return ResponseUtils.toStoreResponse(response, endpoint).map(rsp -> new RxDocumentServiceResponse(diagnosticsClientContext, (StoreResponse)rsp));
            }
            return HttpClientUtils.createDocumentClientException(request, response).flatMap(Mono::error);
        });
    }

    private static Mono<CosmosException> createDocumentClientException(RxDocumentServiceRequest request, HttpResponse httpResponse) {
        Mono readStream = httpResponse.bodyAsString().switchIfEmpty(Mono.just((Object)""));
        return readStream.map(body -> {
            CosmosError cosmosError = new CosmosError((String)body);
            return BridgeInternal.createCosmosException(request.requestContext.resourcePhysicalAddress, httpResponse.statusCode(), cosmosError, httpResponse.headers().toMap());
        });
    }
}

