/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdFramer;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdResponseDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RntbdResponseDecoder.class);
    private static final AtomicReference<Instant> decodeStartTime = new AtomicReference();

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        RntbdResponse response;
        decodeStartTime.compareAndSet(null, Instant.now());
        if (RntbdFramer.canDecodeHead(in) && (response = RntbdResponse.decode(in)) != null) {
            response.setDecodeEndTime(Instant.now());
            response.setDecodeStartTime(decodeStartTime.getAndSet(null));
            logger.debug("{} DECODE COMPLETE: {}", (Object)context.channel(), (Object)response);
            in.discardReadBytes();
            out.add(response.retain());
        }
    }
}

