/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.query.metrics.SchedulingStopwatch;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;

public class HybridSearchCumulativeSchedulingStopWatch
extends SchedulingStopwatch {
    private long cumulativeRunTime = 0L;
    private StopWatch runTimeStopwatch = new StopWatch();
    private long numPreemptions;
    private boolean responded;

    @Override
    public SchedulingTimeSpan getElapsedTime() {
        SchedulingTimeSpan parentTimeSpan = super.getElapsedTime();
        long totalRunTime = this.cumulativeRunTime;
        if (this.runTimeStopwatch.isStarted()) {
            totalRunTime += this.runTimeStopwatch.getTime();
        }
        return new SchedulingTimeSpan(parentTimeSpan.getTurnaroundTime(), parentTimeSpan.getResponseTime(), totalRunTime, parentTimeSpan.getTurnaroundTime() - totalRunTime, this.numPreemptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        StopWatch stopWatch = this.runTimeStopwatch;
        synchronized (stopWatch) {
            if (this.runTimeStopwatch.isStarted()) {
                return;
            }
            if (!this.responded) {
                this.responded = true;
            }
            this.runTimeStopwatch.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        StopWatch stopWatch = this.runTimeStopwatch;
        synchronized (stopWatch) {
            if (!this.runTimeStopwatch.isStarted()) {
                return;
            }
            this.runTimeStopwatch.stop();
            this.cumulativeRunTime += this.runTimeStopwatch.getTime();
            this.runTimeStopwatch.reset();
            ++this.numPreemptions;
        }
    }
}

