/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.Http2ConnectionConfig;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyClient;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.Http2AllocationStrategy;
import reactor.netty.resources.ConnectionProvider;

public interface HttpClient {
    public Mono<HttpResponse> send(HttpRequest var1);

    public Mono<HttpResponse> send(HttpRequest var1, Duration var2);

    public static HttpClient createFixed(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        ConnectionProvider.Builder fixedConnectionProviderBuilder = ConnectionProvider.builder((String)httpClientConfig.getConnectionPoolName());
        fixedConnectionProviderBuilder.maxConnections(httpClientConfig.getMaxPoolSize());
        Integer customPendingAcquireMaxCount = httpClientConfig.getPendingAcquireMaxCount();
        if (customPendingAcquireMaxCount != null) {
            fixedConnectionProviderBuilder.pendingAcquireMaxCount(customPendingAcquireMaxCount.intValue());
        }
        fixedConnectionProviderBuilder.pendingAcquireTimeout(httpClientConfig.getConnectionAcquireTimeout());
        fixedConnectionProviderBuilder.maxIdleTime(httpClientConfig.getMaxIdleConnectionTimeout());
        ImplementationBridgeHelpers.Http2ConnectionConfigHelper.Http2ConnectionConfigAccessor http2CfgAccessor = ImplementationBridgeHelpers.Http2ConnectionConfigHelper.getHttp2ConnectionConfigAccessor();
        Http2ConnectionConfig http2Cfg = httpClientConfig.getHttp2ConnectionConfig();
        if (http2CfgAccessor.isEffectivelyEnabled(http2Cfg)) {
            fixedConnectionProviderBuilder.allocationStrategy((ConnectionProvider.AllocationStrategy)Http2AllocationStrategy.builder().minConnections(http2CfgAccessor.getEffectiveMinConnectionPoolSize(http2Cfg)).maxConnections(http2CfgAccessor.getEffectiveMaxConnectionPoolSize(http2Cfg)).maxConcurrentStreams((long)http2CfgAccessor.getEffectiveMaxConcurrentStreams(http2Cfg)).build());
        }
        return ReactorNettyClient.createWithConnectionProvider(fixedConnectionProviderBuilder.build(), httpClientConfig);
    }

    public static HttpClient create(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        return ReactorNettyClient.create(httpClientConfig);
    }

    public void shutdown();
}

