/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionEvent;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(RntbdConnectionStateListener.class);
    private final IAddressResolver addressResolver;
    private final RntbdEndpoint endpoint;
    private final Set<PartitionKeyRangeIdentity> partitionAddressCache;
    private final AtomicBoolean updatingAddressCache = new AtomicBoolean(false);

    public RntbdConnectionStateListener(IAddressResolver addressResolver, RntbdEndpoint endpoint) {
        this.addressResolver = Preconditions.checkNotNull(addressResolver, "expected non-null addressResolver");
        this.endpoint = Preconditions.checkNotNull(endpoint, "expected non-null endpoint");
        this.partitionAddressCache = ConcurrentHashMap.newKeySet();
    }

    public void onException(RxDocumentServiceRequest request, Throwable exception) {
        Throwable cause;
        Preconditions.checkNotNull(request, "expect non-null request");
        Preconditions.checkNotNull(exception, "expect non-null exception");
        if (exception instanceof GoneException && (cause = exception.getCause()) != null && cause instanceof IOException) {
            if (cause instanceof ClosedChannelException) {
                this.onConnectionEvent(RntbdConnectionEvent.READ_EOF, request, exception);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Will not raise the connection state change event for error {}", cause);
            }
        }
    }

    public void updateConnectionState(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull("expect non-null request");
        PartitionKeyRangeIdentity partitionKeyRangeIdentity = this.getPartitionKeyRangeIdentity(request);
        Preconditions.checkNotNull(partitionKeyRangeIdentity, "expected non-null partitionKeyRangeIdentity");
        this.partitionAddressCache.add(partitionKeyRangeIdentity);
        if (logger.isDebugEnabled()) {
            logger.debug("updateConnectionState({\"time\":{},\"endpoint\":{},\"partitionKeyRangeIdentity\":{}})", new Object[]{RntbdObjectMapper.toJson(Instant.now()), RntbdObjectMapper.toJson(this.endpoint), RntbdObjectMapper.toJson(partitionKeyRangeIdentity)});
        }
    }

    private PartitionKeyRangeIdentity getPartitionKeyRangeIdentity(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "expect non-null request");
        PartitionKeyRangeIdentity partitionKeyRangeIdentity = request.getPartitionKeyRangeIdentity();
        if (partitionKeyRangeIdentity == null) {
            String partitionKeyRange = Preconditions.checkNotNull(request.requestContext.resolvedPartitionKeyRange, "expected non-null resolvedPartitionKeyRange").getId();
            String collectionRid = request.requestContext.resolvedCollectionRid;
            partitionKeyRangeIdentity = collectionRid != null ? new PartitionKeyRangeIdentity(collectionRid, partitionKeyRange) : new PartitionKeyRangeIdentity(partitionKeyRange);
        }
        return partitionKeyRangeIdentity;
    }

    private void onConnectionEvent(RntbdConnectionEvent event, RxDocumentServiceRequest request, Throwable exception) {
        Preconditions.checkNotNull(request, "expected non-null exception");
        Preconditions.checkNotNull(exception, "expected non-null exception");
        if (event == RntbdConnectionEvent.READ_EOF && !this.endpoint.isClosed()) {
            if (logger.isDebugEnabled()) {
                logger.debug("onConnectionEvent({\"event\":{},\"time\":{},\"endpoint\":{},\"cause\":{})", new Object[]{event, RntbdObjectMapper.toJson(Instant.now()), RntbdObjectMapper.toJson(this.endpoint), RntbdObjectMapper.toJson(exception)});
            }
            this.updateAddressCache(request);
        }
    }

    private void updateAddressCache(RxDocumentServiceRequest request) {
        try {
            if (this.updatingAddressCache.compareAndSet(false, true)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("updateAddressCache ({\"time\":{},\"endpoint\":{},\"partitionAddressCache\":{}})", new Object[]{RntbdObjectMapper.toJson(Instant.now()), RntbdObjectMapper.toJson(this.endpoint), RntbdObjectMapper.toJson(this.partitionAddressCache)});
                }
                this.addressResolver.remove(request, this.partitionAddressCache);
                this.partitionAddressCache.clear();
            }
        }
        finally {
            this.updatingAddressCache.set(false);
        }
    }
}

