/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchExecUtils {
    private static final Logger logger = LoggerFactory.getLogger(BatchExecUtils.class);

    public static Duration getRetryAfterDuration(Map<String, String> responseHeaders) {
        String header;
        long retryIntervalInMilliseconds = 0L;
        if (responseHeaders != null && StringUtils.isNotEmpty(header = responseHeaders.get("x-ms-retry-after-ms"))) {
            try {
                retryIntervalInMilliseconds = Long.parseLong(header);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Duration.ofMillis(retryIntervalInMilliseconds);
    }

    public static String getSessionToken(Map<String, String> responseHeaders) {
        if (responseHeaders != null) {
            return responseHeaders.get("x-ms-session-token");
        }
        return null;
    }

    public static String getActivityId(Map<String, String> responseHeaders) {
        if (responseHeaders != null) {
            return responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public static double getRequestCharge(Map<String, String> responseHeaders) {
        if (responseHeaders == null) {
            return 0.0;
        }
        String value = responseHeaders.get("x-ms-request-charge");
        if (StringUtils.isEmpty(value)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.warn("INVALID x-ms-request-charge value {}.", (Object)value);
            return 0.0;
        }
    }

    public static int getSubStatusCode(Map<String, String> responseHeaders) {
        String subStatusString;
        int code = 0;
        if (responseHeaders != null && StringUtils.isNotEmpty(subStatusString = responseHeaders.get("x-ms-substatus"))) {
            try {
                code = Integer.parseInt(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }
}

