/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosItemOperationType;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.TransactionalBatchOperationResult;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BulkOperationRetryPolicy;
import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.batch.PartitionKeyRangeServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerOperationBatchRequest;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

final class BulkExecutorUtil {
    BulkExecutorUtil() {
    }

    static ServerOperationBatchRequest createBatchRequest(List<CosmosItemOperation> operations, String partitionKeyRangeId) {
        return PartitionKeyRangeServerBatchRequest.createBatchRequest(partitionKeyRangeId, operations, 220201, 100);
    }

    static void setRetryPolicyForBulk(AsyncDocumentClient docClientWrapper, CosmosAsyncContainer container, CosmosItemOperation cosmosItemOperation, ThrottlingRetryOptions throttlingRetryOptions) {
        if (!(cosmosItemOperation instanceof ItemBulkOperation)) {
            throw new UnsupportedOperationException("Unknown CosmosItemOperation.");
        }
        ItemBulkOperation itemBulkOperation = (ItemBulkOperation)cosmosItemOperation;
        ResourceThrottleRetryPolicy resourceThrottleRetryPolicy = new ResourceThrottleRetryPolicy(throttlingRetryOptions.getMaxRetryAttemptsOnThrottledRequests(), throttlingRetryOptions.getMaxRetryWaitTime());
        BulkOperationRetryPolicy bulkRetryPolicy = new BulkOperationRetryPolicy(docClientWrapper.getCollectionCache(), BridgeInternal.getLink(container), resourceThrottleRetryPolicy);
        itemBulkOperation.setRetryPolicy(bulkRetryPolicy);
    }

    static Map<String, String> getResponseHeadersFromBatchOperationResult(TransactionalBatchOperationResult result) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-substatus", String.valueOf(result.getSubStatusCode()));
        headers.put("etag", result.getETag());
        headers.put("x-ms-request-charge", String.valueOf(result.getRequestCharge()));
        if (result.getRetryAfterDuration() != null) {
            headers.put("x-ms-retry-after-ms", String.valueOf(result.getRetryAfterDuration().toMillis()));
        }
        return headers;
    }

    static Mono<String> resolvePartitionKeyRangeId(AsyncDocumentClient docClientWrapper, CosmosAsyncContainer container, CosmosItemOperation operation) {
        Preconditions.checkNotNull(operation, "expected non-null operation");
        if (operation instanceof ItemBulkOperation) {
            ItemBulkOperation itemBulkOperation = (ItemBulkOperation)operation;
            Mono pkRangeIdMono = BulkExecutorUtil.getCollectionInfoAsync(docClientWrapper, container).flatMap(collection -> {
                PartitionKeyDefinition definition = collection.getPartitionKey();
                PartitionKeyInternal partitionKeyInternal = BulkExecutorUtil.getPartitionKeyInternal(operation, definition);
                itemBulkOperation.setPartitionKeyJson(partitionKeyInternal.toJson());
                return docClientWrapper.getPartitionKeyRangeCache().tryLookupAsync(null, collection.getResourceId(), null, null).map(routingMap -> ((CollectionRoutingMap)routingMap.v).getRangeByEffectivePartitionKey(PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, definition)).getId());
            });
            return pkRangeIdMono;
        }
        throw new UnsupportedOperationException("Unknown CosmosItemOperation.");
    }

    private static PartitionKeyInternal getPartitionKeyInternal(CosmosItemOperation operation, PartitionKeyDefinition partitionKeyDefinition) {
        Preconditions.checkNotNull(operation, "expected non-null operation");
        PartitionKey partitionKey = operation.getPartitionKeyValue();
        if (partitionKey == null) {
            return ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        }
        return BridgeInternal.getPartitionKeyInternal(partitionKey);
    }

    private static Mono<DocumentCollection> getCollectionInfoAsync(AsyncDocumentClient documentClient, CosmosAsyncContainer container) {
        String resourceAddress = Utils.joinPath(BridgeInternal.getLink(container), null);
        RxClientCollectionCache clientCollectionCache = documentClient.getCollectionCache();
        return clientCollectionCache.resolveByNameAsync(null, resourceAddress, null);
    }

    static boolean isWriteOperation(CosmosItemOperationType cosmosItemOperationType) {
        return cosmosItemOperationType == CosmosItemOperationType.CREATE || cosmosItemOperationType == CosmosItemOperationType.REPLACE || cosmosItemOperationType == CosmosItemOperationType.UPSERT || cosmosItemOperationType == CosmosItemOperationType.DELETE;
    }
}

