/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.feedranges.FeedRangeCompositeContinuationImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuationVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.Range;
import java.util.Map;
import java.util.function.BiConsumer;

final class FeedRangeContinuationRxDocumentServiceRequestPopulatorVisitorImpl
extends FeedRangeContinuationVisitor {
    private final RxDocumentServiceRequest request;
    private final BiConsumer<RxDocumentServiceRequest, String> fillContinuation;

    public FeedRangeContinuationRxDocumentServiceRequestPopulatorVisitorImpl(RxDocumentServiceRequest request, BiConsumer<RxDocumentServiceRequest, String> fillContinuation) {
        Preconditions.checkNotNull(request, "'request' must not be null");
        Preconditions.checkNotNull(fillContinuation, "'fillContinuation' must not be null");
        this.request = request;
        this.fillContinuation = fillContinuation;
    }

    @Override
    public void visit(FeedRangeCompositeContinuationImpl feedRangeCompositeContinuation) {
        Preconditions.checkNotNull(feedRangeCompositeContinuation, "'feedRangeCompositeContinuation' must not be null");
        Map<String, Object> properties = this.request.getPropertiesOrThrow();
        if (properties.containsKey("x-ms-start-epk-string")) {
            return;
        }
        Range<String> range = feedRangeCompositeContinuation.getCurrentToken().getRange();
        properties.put("x-ms-end-epk-string", range.getMax());
        properties.put("x-ms-start-epk-string", range.getMin());
        this.fillContinuation.accept(this.request, feedRangeCompositeContinuation.getContinuation());
    }
}

