/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeAsyncVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeVisitor;
import com.azure.cosmos.implementation.feedranges.GenericFeedRangeVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

final class FeedRangePartitionKeyImpl
extends FeedRangeInternal {
    private final PartitionKeyInternal partitionKey;

    public FeedRangePartitionKeyImpl(PartitionKeyInternal partitionKey) {
        Preconditions.checkNotNull(partitionKey, "Argument 'partitionKey' must not be null");
        this.partitionKey = partitionKey;
    }

    public PartitionKeyInternal getPartitionKeyInternal() {
        return this.partitionKey;
    }

    @Override
    public void accept(FeedRangeVisitor visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this);
    }

    @Override
    public <TInput> void accept(GenericFeedRangeVisitor<TInput> visitor, TInput input) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this, input);
    }

    @Override
    public <T> Mono<T> accept(FeedRangeAsyncVisitor<T> visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        return visitor.visit(this);
    }

    @Override
    public Mono<UnmodifiableList<Range<String>>> getEffectiveRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        String effectivePartitionKey = this.partitionKey.getEffectivePartitionKeyString(this.partitionKey, partitionKeyDefinition);
        Range<String> range = Range.getPointRange(effectivePartitionKey);
        ArrayList<Range<String>> rangeList = new ArrayList<Range<String>>();
        rangeList.add(range);
        return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(rangeList)));
    }

    @Override
    public Mono<UnmodifiableList<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        String effectivePartitionKey = this.partitionKey.getEffectivePartitionKeyString(this.partitionKey, partitionKeyDefinition);
        return routingMapProvider.tryGetOverlappingRangesAsync(null, containerRid, Range.getPointRange(effectivePartitionKey), false, null).flatMap(pkRangeHolder -> {
            ArrayList<String> rangeList = new ArrayList<String>();
            if (pkRangeHolder != null) {
                String rangeId = ((PartitionKeyRange)((List)pkRangeHolder.v).get(0)).getId();
                rangeList.add(rangeId);
            }
            return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(rangeList)));
        });
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.partitionKey != null) {
            BridgeInternal.setProperty(this, "PartitionKey", this.partitionKey);
        }
    }

    @Override
    public String toString() {
        return this.partitionKey.toJson();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangePartitionKeyImpl that = (FeedRangePartitionKeyImpl)o;
        return Objects.equals(this.partitionKey, that.partitionKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionKey);
    }
}

