/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.implementation.feedranges.GenericFeedRangeVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.Range;
import java.util.Map;

final class FeedRangeRxDocumentServiceRequestPopulatorVisitorImpl
extends GenericFeedRangeVisitor<RxDocumentServiceRequest> {
    public static final FeedRangeRxDocumentServiceRequestPopulatorVisitorImpl SINGLETON = new FeedRangeRxDocumentServiceRequestPopulatorVisitorImpl();

    private FeedRangeRxDocumentServiceRequestPopulatorVisitorImpl() {
    }

    @Override
    public void visit(FeedRangeEpkImpl feedRange, RxDocumentServiceRequest rxDocumentServiceRequest) {
        Preconditions.checkNotNull(feedRange, "'feedRange' must not be null");
        Preconditions.checkNotNull(rxDocumentServiceRequest, "'rxDocumentServiceRequest' must not be null");
        Map<String, Object> properties = rxDocumentServiceRequest.getPropertiesOrThrow();
        if (properties.containsKey("x-ms-start-epk-string")) {
            return;
        }
        Range<String> range = feedRange.getRange();
        properties.put("x-ms-end-epk-string", range.getMax());
        properties.put("x-ms-start-epk-string", range.getMin());
    }

    @Override
    public void visit(FeedRangePartitionKeyRangeImpl feedRange, RxDocumentServiceRequest rxDocumentServiceRequest) {
        Preconditions.checkNotNull(feedRange, "'feedRange' must not be null");
        Preconditions.checkNotNull(rxDocumentServiceRequest, "'rxDocumentServiceRequest' must not be null");
        rxDocumentServiceRequest.routeTo(feedRange.getPartitionKeyRangeIdentity());
    }

    @Override
    public void visit(FeedRangePartitionKeyImpl feedRange, RxDocumentServiceRequest rxDocumentServiceRequest) {
        Preconditions.checkNotNull(feedRange, "'feedRange' must not be null");
        Preconditions.checkNotNull(rxDocumentServiceRequest, "'rxDocumentServiceRequest' must not be null");
        rxDocumentServiceRequest.getHeaders().put("x-ms-documentdb-partitionkey", feedRange.getPartitionKeyInternal().toJson());
        rxDocumentServiceRequest.setPartitionKeyInternal(feedRange.getPartitionKeyInternal());
    }
}

