/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationServiceVersion;
import com.azure.data.appconfiguration.implementation.ConfigurationClientCredentials;
import com.azure.data.appconfiguration.implementation.ConfigurationCredentialsPolicy;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ConfigurationAsyncClient.class, ConfigurationClient.class})
public final class ConfigurationClientBuilder {
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final HttpPipelinePolicy ADD_HEADERS_POLICY;
    private final ClientLogger logger = new ClientLogger(ConfigurationClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private ConfigurationClientCredentials credential;
    private TokenCredential tokenCredential;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private HttpPipelinePolicy retryPolicy;
    private Configuration configuration;
    private ConfigurationServiceVersion version;

    public ConfigurationClient buildClient() {
        return new ConfigurationClient(this.buildAsyncClient());
    }

    public ConfigurationAsyncClient buildAsyncClient() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ConfigurationServiceVersion serviceVersion = this.version != null ? this.version : ConfigurationServiceVersion.getLatest();
        String buildEndpoint = this.endpoint;
        if (this.tokenCredential == null) {
            buildEndpoint = this.getBuildEndpoint();
        }
        Objects.requireNonNull(buildEndpoint, "'Endpoint' is required and can not be null.");
        SyncTokenPolicy syncTokenPolicy = new SyncTokenPolicy();
        if (this.pipeline != null) {
            return new ConfigurationAsyncClient(buildEndpoint, this.pipeline, serviceVersion, syncTokenPolicy);
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions), CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        policies.add(ADD_HEADERS_POLICY);
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{String.format("%s/.default", buildEndpoint)}));
        } else if (this.credential != null) {
            policies.add(new ConfigurationCredentialsPolicy(this.credential));
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        policies.add(syncTokenPolicy);
        policies.addAll(this.perRetryPolicies);
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new ConfigurationAsyncClient(buildEndpoint, pipeline, serviceVersion, syncTokenPolicy);
    }

    public ConfigurationClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL"));
        }
        this.endpoint = endpoint;
        return this;
    }

    public ConfigurationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConfigurationClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        if (connectionString.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot be an empty string."));
        }
        try {
            this.credential = new ConfigurationClientCredentials(connectionString);
        }
        catch (InvalidKeyException err) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The secret contained within the connection string is invalid and cannot instantiate the HMAC-SHA256 algorithm.", err));
        }
        catch (NoSuchAlgorithmException err) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("HMAC-SHA256 MAC algorithm cannot be instantiated.", err));
        }
        this.endpoint = this.credential.getBaseUri();
        return this;
    }

    public ConfigurationClientBuilder credential(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential);
        this.tokenCredential = tokenCredential;
        return this;
    }

    public ConfigurationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public ConfigurationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public ConfigurationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public ConfigurationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ConfigurationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ConfigurationClientBuilder retryPolicy(HttpPipelinePolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ConfigurationClientBuilder serviceVersion(ConfigurationServiceVersion version) {
        this.version = version;
        return this;
    }

    private String getBuildEndpoint() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (this.credential != null) {
            return this.credential.getBaseUri();
        }
        return null;
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-data-appconfiguration.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        ADD_HEADERS_POLICY = new AddHeadersPolicy(new HttpHeaders().put("x-ms-return-client-request-id", "true").put("Content-Type", "application/json").put("Accept", "application/vnd.microsoft.azconfig.kv+json"));
    }
}

