/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonDeserializer;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonSerializer;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class FeatureFlagConfigurationSetting
extends ConfigurationSetting {
    private static final ClientLogger LOGGER = new ClientLogger(FeatureFlagConfigurationSetting.class);
    private static final String FEATURE_FLAG_CONTENT_TYPE = "application/vnd.microsoft.appconfig.ff+json;charset=utf-8";
    private String featureId;
    private boolean isEnabled;
    private String description;
    private String displayName;
    private List<FeatureFlagFilter> clientFilters;
    public static final String KEY_PREFIX = ".appconfig.featureflag/";

    public FeatureFlagConfigurationSetting(String featureId, boolean isEnabled) {
        this.featureId = featureId;
        this.isEnabled = isEnabled;
        super.setKey(KEY_PREFIX + featureId);
        super.setContentType(FEATURE_FLAG_CONTENT_TYPE);
    }

    @Override
    public FeatureFlagConfigurationSetting setKey(String key) {
        super.setKey(key);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setValue(String value) {
        super.setValue(value);
        FeatureFlagConfigurationSetting updatedSetting = ConfigurationSettingJsonDeserializer.readFeatureFlagConfigurationSettingValue(value);
        this.featureId = updatedSetting.getFeatureId();
        this.description = updatedSetting.getDescription();
        this.isEnabled = updatedSetting.isEnabled();
        this.displayName = updatedSetting.getDisplayName();
        this.clientFilters = StreamSupport.stream(updatedSetting.getClientFilters().spliterator(), false).collect(Collectors.toList());
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setETag(String etag) {
        super.setETag(etag);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public FeatureFlagConfigurationSetting setFeatureId(String featureId) {
        this.featureId = featureId;
        super.setKey(KEY_PREFIX + featureId);
        this.updateSettingValue();
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public FeatureFlagConfigurationSetting setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.updateSettingValue();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public FeatureFlagConfigurationSetting setDescription(String description) {
        this.description = description;
        this.updateSettingValue();
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FeatureFlagConfigurationSetting setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updateSettingValue();
        return this;
    }

    public List<FeatureFlagFilter> getClientFilters() {
        if (this.clientFilters == null) {
            this.clientFilters = new ArrayList<FeatureFlagFilter>();
        }
        return this.clientFilters;
    }

    public FeatureFlagConfigurationSetting setClientFilters(List<FeatureFlagFilter> clientFilters) {
        this.clientFilters = clientFilters;
        this.updateSettingValue();
        return this;
    }

    public FeatureFlagConfigurationSetting addClientFilter(FeatureFlagFilter clientFilter) {
        if (this.clientFilters == null) {
            this.clientFilters = new ArrayList<FeatureFlagFilter>();
        }
        this.clientFilters.add(clientFilter);
        this.updateSettingValue();
        return this;
    }

    private void updateSettingValue() {
        try {
            super.setValue(ConfigurationSettingJsonSerializer.writeFeatureFlagConfigurationSetting(this));
        }
        catch (IOException exception) {
            LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Can't parse Feature Flag configuration setting value.", exception));
        }
    }
}

