/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.data.appconfiguration.implementation.AzureAppConfigurationImpl;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.implementation.models.SnapshotUpdateParameters;
import com.azure.data.appconfiguration.implementation.models.UpdateSnapshotHeaders;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSettingSnapshot;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SnapshotStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class Utility {
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    public static final String APP_CONFIG_TRACING_NAMESPACE_VALUE = "Microsoft.AppConfiguration";
    static final String ID = "id";
    static final String DESCRIPTION = "description";
    static final String DISPLAY_NAME = "display_name";
    static final String ENABLED = "enabled";
    static final String CONDITIONS = "conditions";
    static final String CLIENT_FILTERS = "client_filters";
    static final String NAME = "name";
    static final String PARAMETERS = "parameters";
    static final String URI = "uri";
    public static final String ETAG_ANY = "*";

    public static KeyValue toKeyValue(ConfigurationSetting setting) {
        return new KeyValue().setKey(setting.getKey()).setValue(setting.getValue()).setLabel(setting.getLabel()).setContentType(setting.getContentType()).setEtag(setting.getETag()).setLastModified(setting.getLastModified()).setLocked(setting.isReadOnly()).setTags(setting.getTags());
    }

    public static SettingFields[] toSettingFieldsArray(List<SettingFields> settingFieldsList) {
        int size = settingFieldsList.size();
        SettingFields[] fields = new SettingFields[size];
        for (int i = 0; i < size; ++i) {
            fields[i] = settingFieldsList.get(i);
        }
        return fields;
    }

    public static List<SettingFields> toSettingFieldsList(SettingFields[] settingFieldsArray) {
        int size = settingFieldsArray.length;
        ArrayList<SettingFields> settingFieldsList = new ArrayList<SettingFields>(size);
        for (int i = 0; i < size; ++i) {
            settingFieldsList.add(settingFieldsArray[i]);
        }
        return settingFieldsList;
    }

    public static <E> List<E> iterableToList(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<E> outputList = new ArrayList<E>();
        for (E item : iterable) {
            outputList.add(item);
        }
        return outputList;
    }

    private static String getETagValue(String etag) {
        return etag == null || ETAG_ANY.equals(etag) ? etag : "\"" + etag + "\"";
    }

    public static String getETag(boolean isETagRequired, ConfigurationSetting setting) {
        return isETagRequired ? Utility.getETagValue(setting.getETag()) : null;
    }

    public static String getETagSnapshot(boolean isETagRequired, ConfigurationSettingSnapshot snapshot) {
        if (!isETagRequired) {
            return null;
        }
        Objects.requireNonNull(snapshot);
        return Utility.getETagValue(snapshot.getETag());
    }

    public static void validateSetting(ConfigurationSetting setting) {
        Objects.requireNonNull(setting);
        if (setting.getKey() == null) {
            throw new IllegalArgumentException("Parameter 'key' is required and cannot be null.");
        }
    }

    public static Mono<ConfigurationSetting> validateSettingAsync(ConfigurationSetting setting) {
        if (setting == null) {
            return Mono.error((Throwable)new NullPointerException("Configuration setting cannot be null"));
        }
        if (setting.getKey() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'key' is required and cannot be null."));
        }
        return Mono.just((Object)setting);
    }

    public static Context enableSyncRestProxy(Context context) {
        context = context == null ? Context.NONE : context;
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    public static Context addTracingNamespace(Context context) {
        context = context == null ? Context.NONE : context;
        return context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE);
    }

    public static Response<ConfigurationSettingSnapshot> updateSnapshotSync(String snapshotName, ConfigurationSettingSnapshot snapshot, SnapshotStatus status, boolean ifUnchanged, AzureAppConfigurationImpl serviceClient, Context context) {
        ResponseBase<UpdateSnapshotHeaders, ConfigurationSettingSnapshot> response = serviceClient.updateSnapshotWithResponse(snapshotName, new SnapshotUpdateParameters().setStatus(status), Utility.getETagSnapshot(ifUnchanged, snapshot), null, context);
        return new SimpleResponse(response, (Object)((ConfigurationSettingSnapshot)response.getValue()));
    }

    public static Mono<Response<ConfigurationSettingSnapshot>> updateSnapshotAsync(String snapshotName, ConfigurationSettingSnapshot snapshot, SnapshotStatus status, boolean ifUnchanged, AzureAppConfigurationImpl serviceClient) {
        return serviceClient.updateSnapshotWithResponseAsync(snapshotName, new SnapshotUpdateParameters().setStatus(status), Utility.getETagSnapshot(ifUnchanged, snapshot), null).map(response -> new SimpleResponse((Response)response, (Object)((ConfigurationSettingSnapshot)response.getValue())));
    }
}

