// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** An object containing specific information about an error. */
@Fluent
public final class InnerError implements JsonSerializable<InnerError> {
    /*
     * One of a server-defined set of error codes.
     */
    private String code;

    /*
     * An object containing more specific information than the current object about the error.
     */
    private InnerError innererror;

    /** Creates an instance of InnerError class. */
    public InnerError() {}

    /**
     * Get the code property: One of a server-defined set of error codes.
     *
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: One of a server-defined set of error codes.
     *
     * @param code the code value to set.
     * @return the InnerError object itself.
     */
    public InnerError setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the innererror property: An object containing more specific information than the current object about the
     * error.
     *
     * @return the innererror value.
     */
    public InnerError getInnererror() {
        return this.innererror;
    }

    /**
     * Set the innererror property: An object containing more specific information than the current object about the
     * error.
     *
     * @param innererror the innererror value to set.
     * @return the InnerError object itself.
     */
    public InnerError setInnererror(InnerError innererror) {
        this.innererror = innererror;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeJsonField("innererror", this.innererror);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InnerError from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of InnerError if the JsonReader was pointing to an instance of it, or null if it was pointing
     *     to JSON null.
     * @throws IOException If an error occurs while reading the InnerError.
     */
    public static InnerError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    InnerError deserializedInnerError = new InnerError();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("code".equals(fieldName)) {
                            deserializedInnerError.code = reader.getString();
                        } else if ("innererror".equals(fieldName)) {
                            deserializedInnerError.innererror = InnerError.fromJson(reader);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedInnerError;
                });
    }
}
