// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The Label model. */
@Immutable
public final class Label implements JsonSerializable<Label> {
    /*
     * The name of the label.
     */
    private String name;

    /** Creates an instance of Label class. */
    public Label() {}

    /**
     * Get the name property: The name of the label.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Label from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Label if the JsonReader was pointing to an instance of it, or null if it was pointing to
     *     JSON null.
     * @throws IOException If an error occurs while reading the Label.
     */
    public static Label fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    Label deserializedLabel = new Label();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("name".equals(fieldName)) {
                            deserializedLabel.name = reader.getString();
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedLabel;
                });
    }
}
