// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

/** The current status of the operation. */
public enum State {
    /** Enum value NotStarted. */
    NOT_STARTED("NotStarted"),

    /** Enum value Running. */
    RUNNING("Running"),

    /** Enum value Succeeded. */
    SUCCEEDED("Succeeded"),

    /** Enum value Failed. */
    FAILED("Failed"),

    /** Enum value Canceled. */
    CANCELED("Canceled");

    /** The actual serialized value for a State instance. */
    private final String value;

    State(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a State instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed State object, or null if unable to parse.
     */
    public static State fromString(String value) {
        if (value == null) {
            return null;
        }
        State[] items = State.values();
        for (State item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
