// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The composition type describes how the key-values within the snapshot are composed. The 'key' composition type
 * ensures there are no two key-values containing the same key. The 'key_label' composition type ensures there are no
 * two key-values containing the same key and label.
 */
public final class SnapshotComposition extends ExpandableStringEnum<SnapshotComposition> {
    /** Static value key for SnapshotComposition. */
    public static final SnapshotComposition KEY = fromString("key");

    /** Static value key_label for SnapshotComposition. */
    public static final SnapshotComposition KEY_LABEL = fromString("key_label");

    /**
     * Creates a new instance of SnapshotComposition value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SnapshotComposition() {}

    /**
     * Creates or finds a SnapshotComposition from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SnapshotComposition.
     */
    public static SnapshotComposition fromString(String name) {
        return fromString(name, SnapshotComposition.class);
    }

    /**
     * Gets known SnapshotComposition values.
     *
     * @return known SnapshotComposition values.
     */
    public static Collection<SnapshotComposition> values() {
        return values(SnapshotComposition.class);
    }
}
