/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollOperationDetails;
import com.azure.core.util.polling.PollerFlux;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.implementation.AzureAppConfigurationImpl;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingDeserializationHelper;
import com.azure.data.appconfiguration.implementation.CreateSnapshotUtilClient;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import com.azure.data.appconfiguration.implementation.Utility;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.data.appconfiguration.models.SnapshotFields;
import com.azure.data.appconfiguration.models.SnapshotSelector;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ConfigurationClientBuilder.class, isAsync=true, serviceInterfaces={AzureAppConfigurationImpl.AzureAppConfigurationService.class})
public final class ConfigurationAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationAsyncClient.class);
    private final AzureAppConfigurationImpl serviceClient;
    private final SyncTokenPolicy syncTokenPolicy;
    final CreateSnapshotUtilClient createSnapshotUtilClient;

    ConfigurationAsyncClient(AzureAppConfigurationImpl serviceClient, SyncTokenPolicy syncTokenPolicy) {
        this.serviceClient = serviceClient;
        this.syncTokenPolicy = syncTokenPolicy;
        this.createSnapshotUtilClient = new CreateSnapshotUtilClient(serviceClient);
    }

    public String getEndpoint() {
        return this.serviceClient.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(String key, String label, String value) {
        return this.addConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(ConfigurationSetting setting) {
        return this.addConfigurationSettingWithResponse(setting).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> addConfigurationSettingWithResponse(ConfigurationSetting setting) {
        return FluxUtil.withContext(context -> Utility.validateSettingAsync(setting).flatMap(settingInternal -> this.serviceClient.putKeyValueWithResponseAsync(settingInternal.getKey(), settingInternal.getLabel(), null, "*", Utility.toKeyValue(settingInternal), Utility.addTracingNamespace(context)).map(response -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse((Response<KeyValue>)response))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(String key, String label, String value) {
        return this.setConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(ConfigurationSetting setting) {
        return this.setConfigurationSettingWithResponse(setting, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        return FluxUtil.withContext(context -> Utility.validateSettingAsync(setting).flatMap(settingInternal -> this.serviceClient.putKeyValueWithResponseAsync(settingInternal.getKey(), settingInternal.getLabel(), Utility.getETag(ifUnchanged, settingInternal), null, Utility.toKeyValue(settingInternal), Utility.addTracingNamespace(context)).map(response -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse((Response<KeyValue>)response))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label) {
        return this.getConfigurationSetting(key, label, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label, OffsetDateTime acceptDateTime) {
        return this.getConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), acceptDateTime, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(ConfigurationSetting setting) {
        return this.getConfigurationSettingWithResponse(setting, null, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean ifChanged) {
        return FluxUtil.withContext(context -> Utility.validateSettingAsync(setting).flatMap(settingInternal -> this.serviceClient.getKeyValueWithResponseAsync(settingInternal.getKey(), settingInternal.getLabel(), acceptDateTime == null ? null : acceptDateTime.toString(), null, Utility.getETag(ifChanged, settingInternal), null, Utility.addTracingNamespace(context)).onErrorResume(HttpResponseException.class, throwable -> {
            HttpResponseException e = (HttpResponseException)((Object)((Object)((Object)throwable)));
            HttpResponse httpResponse = e.getResponse();
            if (httpResponse.getStatusCode() == 304) {
                return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, null));
            }
            return Mono.error((Throwable)throwable);
        }).map(response -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse((Response<KeyValue>)response))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(String key, String label) {
        return this.deleteConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(ConfigurationSetting setting) {
        return this.deleteConfigurationSettingWithResponse(setting, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        return FluxUtil.withContext(context -> Utility.validateSettingAsync(setting).flatMap(settingInternal -> this.serviceClient.deleteKeyValueWithResponseAsync(settingInternal.getKey(), settingInternal.getLabel(), Utility.getETag(ifUnchanged, settingInternal), Utility.addTracingNamespace(context)).map(response -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse((Response<KeyValue>)response))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(String key, String label, boolean isReadOnly) {
        return this.setReadOnly(new ConfigurationSetting().setKey(key).setLabel(label), isReadOnly);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(ConfigurationSetting setting, boolean isReadOnly) {
        return this.setReadOnlyWithResponse(setting, isReadOnly).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly) {
        return FluxUtil.withContext(context -> Utility.validateSettingAsync(setting).flatMap(settingInternal -> {
            String key = settingInternal.getKey();
            String label = settingInternal.getLabel();
            Context contextInternal = Utility.addTracingNamespace(context);
            return (isReadOnly ? this.serviceClient.putLockWithResponseAsync(key, label, null, null, contextInternal) : this.serviceClient.deleteLockWithResponseAsync(key, label, null, null, contextInternal)).map(response -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse((Response<KeyValue>)response));
        }));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listConfigurationSettings(SettingSelector selector) {
        String keyFilter = selector == null ? null : selector.getKeyFilter();
        String labelFilter = selector == null ? null : selector.getLabelFilter();
        String acceptDateTime = selector == null ? null : selector.getAcceptDateTime();
        List<SettingFields> settingFields = selector == null ? null : Utility.toSettingFieldsList(selector.getFields());
        List<MatchConditions> matchConditionsList = selector == null ? null : selector.getMatchConditions();
        AtomicInteger pageETagIndex = new AtomicInteger(0);
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.serviceClient.getKeyValuesSinglePageAsync(keyFilter, labelFilter, null, acceptDateTime, settingFields, null, null, Utility.getPageETag(matchConditionsList, pageETagIndex), Utility.addTracingNamespace(context)).onErrorResume(HttpResponseException.class, throwable -> Utility.handleNotModifiedErrorToValidResponse(throwable)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))), nextLink -> FluxUtil.withContext(context -> this.serviceClient.getKeyValuesNextSinglePageAsync((String)nextLink, acceptDateTime, null, Utility.getPageETag(matchConditionsList, pageETagIndex), Utility.addTracingNamespace(context)).onErrorResume(HttpResponseException.class, throwable -> Utility.handleNotModifiedErrorToValidResponse(throwable)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listConfigurationSettingsForSnapshot(String snapshotName) {
        return this.listConfigurationSettingsForSnapshot(snapshotName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listConfigurationSettingsForSnapshot(String snapshotName, List<SettingFields> fields) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.serviceClient.getKeyValuesSinglePageAsync(null, null, null, null, fields, snapshotName, null, null, Utility.addTracingNamespace(context)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))), nextLink -> FluxUtil.withContext(context -> this.serviceClient.getKeyValuesNextSinglePageAsync((String)nextLink, null, null, null, Utility.addTracingNamespace(context)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listRevisions(SettingSelector selector) {
        String keyFilter = selector == null ? null : selector.getKeyFilter();
        String labelFilter = selector == null ? null : selector.getLabelFilter();
        String acceptDateTime = selector == null ? null : selector.getAcceptDateTime();
        List<SettingFields> settingFields = selector == null ? null : Utility.toSettingFieldsList(selector.getFields());
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.serviceClient.getRevisionsSinglePageAsync(keyFilter, labelFilter, null, acceptDateTime, settingFields, Utility.addTracingNamespace(context)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))), nextLink -> FluxUtil.withContext(context -> this.serviceClient.getRevisionsNextSinglePageAsync((String)nextLink, acceptDateTime, Utility.addTracingNamespace(context)).map(pagedResponse -> ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse((PagedResponse<KeyValue>)pagedResponse))));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollOperationDetails, ConfigurationSnapshot> beginCreateSnapshot(String snapshotName, ConfigurationSnapshot snapshot) {
        return this.createSnapshotUtilClient.beginCreateSnapshot(snapshotName, snapshot);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> getSnapshot(String snapshotName) {
        return this.getSnapshotWithResponse(snapshotName, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> getSnapshotWithResponse(String snapshotName, List<SnapshotFields> fields) {
        return this.serviceClient.getSnapshotWithResponseAsync(snapshotName, null, null, fields, Context.NONE).map(response -> new SimpleResponse((Response)response, (Object)((ConfigurationSnapshot)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> archiveSnapshot(String snapshotName) {
        return Utility.updateSnapshotAsync(snapshotName, null, ConfigurationSnapshotStatus.ARCHIVED, this.serviceClient).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> archiveSnapshotWithResponse(String snapshotName, MatchConditions matchConditions) {
        return Utility.updateSnapshotAsync(snapshotName, matchConditions, ConfigurationSnapshotStatus.ARCHIVED, this.serviceClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> recoverSnapshot(String snapshotName) {
        return Utility.updateSnapshotAsync(snapshotName, null, ConfigurationSnapshotStatus.READY, this.serviceClient).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> recoverSnapshotWithResponse(String snapshotName, MatchConditions matchConditions) {
        return Utility.updateSnapshotAsync(snapshotName, matchConditions, ConfigurationSnapshotStatus.READY, this.serviceClient);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> listSnapshots(SnapshotSelector selector) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.serviceClient.getSnapshotsSinglePageAsync(selector == null ? null : selector.getNameFilter(), null, selector == null ? null : selector.getFields(), selector == null ? null : selector.getStatus(), Utility.addTracingNamespace(context))), nextLink -> FluxUtil.withContext(context -> this.serviceClient.getSnapshotsNextSinglePageAsync((String)nextLink, Utility.addTracingNamespace(context))));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex));
        }
    }

    public void updateSyncToken(String token) {
        Objects.requireNonNull(token, "'token' cannot be null.");
        this.syncTokenPolicy.updateSyncToken(token);
    }
}

