/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.Exceptions;

public class ConfigurationClientCredentials {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationClientCredentials.class);
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    static final HttpHeaderName X_MS_CONTENT_SHA256 = HttpHeaderName.fromString((String)"x-ms-content-sha256");
    private final CredentialInformation credentials;

    public ConfigurationClientCredentials(String connectionString) {
        this.credentials = new CredentialInformation(connectionString);
    }

    public String getBaseUri() {
        return this.credentials.baseUri().toString();
    }

    void setAuthorizationHeaders(HttpRequest httpRequest) {
        BinaryData binaryData = httpRequest.getBodyAsBinaryData();
        ByteBuffer byteBuffer = binaryData == null ? EMPTY_BYTE_BUFFER : binaryData.toByteBuffer();
        try {
            HttpHeaders headers;
            String date;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            sha256HMAC.init(new SecretKeySpec(this.credentials.secret(), "HmacSHA256"));
            messageDigest.update(byteBuffer.duplicate());
            String contentHash = Base64.getEncoder().encodeToString(messageDigest.digest());
            URL url = httpRequest.getUrl();
            String pathAndQuery = url.getPath();
            if (url.getQuery() != null) {
                pathAndQuery = pathAndQuery + '?' + url.getQuery();
            }
            if ((date = (headers = httpRequest.getHeaders()).getValue(HttpHeaderName.DATE)) == null) {
                date = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now(ZoneOffset.UTC));
                headers.set(HttpHeaderName.DATE, date);
            }
            String signed = url.getHost() + ";" + date + ";" + contentHash;
            headers.set(HttpHeaderName.HOST, url.getHost()).set(X_MS_CONTENT_SHA256, contentHash);
            String stringToSign = httpRequest.getHttpMethod().toString().toUpperCase(Locale.US) + "\n" + pathAndQuery + "\n" + signed;
            String signature = Base64.getEncoder().encodeToString(sha256HMAC.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
            headers.set(HttpHeaderName.AUTHORIZATION, "HMAC-SHA256 Credential=" + this.credentials.id() + "&SignedHeaders=Host;Date;x-ms-content-sha256&Signature=" + signature);
        }
        catch (GeneralSecurityException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }

    private static class CredentialInformation {
        private static final String ENDPOINT = "endpoint=";
        private static final String ID = "id=";
        private static final String SECRET = "secret=";
        private final URL baseUri;
        private final String id;
        private final byte[] secret;

        URL baseUri() {
            return this.baseUri;
        }

        String id() {
            return this.id;
        }

        byte[] secret() {
            return this.secret;
        }

        CredentialInformation(String connectionString) {
            if (CoreUtils.isNullOrEmpty((CharSequence)connectionString)) {
                throw new IllegalArgumentException("'connectionString' cannot be null or empty.");
            }
            String[] args = connectionString.split(";");
            if (args.length < 3) {
                throw new IllegalArgumentException("invalid connection string segment count");
            }
            URL baseUri = null;
            String id = null;
            byte[] secret = null;
            for (String arg : args) {
                String segment = arg.trim();
                if (ENDPOINT.regionMatches(true, 0, segment, 0, ENDPOINT.length())) {
                    try {
                        baseUri = new URL(segment.substring(ENDPOINT.length()));
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                if (ID.regionMatches(true, 0, segment, 0, ID.length())) {
                    id = segment.substring(ID.length());
                    continue;
                }
                if (!SECRET.regionMatches(true, 0, segment, 0, SECRET.length())) continue;
                String secretBase64 = segment.substring(SECRET.length());
                secret = Base64.getDecoder().decode(secretBase64);
            }
            this.baseUri = baseUri;
            this.id = id;
            this.secret = secret;
            if (this.baseUri == null || CoreUtils.isNullOrEmpty((CharSequence)this.id) || this.secret == null || this.secret.length == 0) {
                throw new IllegalArgumentException("Could not parse 'connectionString'. Expected format: 'endpoint={endpoint};id={id};secret={secret}'. Actual:" + connectionString);
            }
        }
    }
}

