/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation.models;

import com.azure.data.appconfiguration.implementation.models.InnerError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ErrorDetail
implements JsonSerializable<ErrorDetail> {
    private final String code;
    private final String message;
    private List<ErrorDetail> details;
    private InnerError innererror;

    public ErrorDetail(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    public ErrorDetail setDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }

    public InnerError getInnererror() {
        return this.innererror;
    }

    public ErrorDetail setInnererror(InnerError innererror) {
        this.innererror = innererror;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        return jsonWriter.writeEndObject();
    }

    public static ErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorDetail)jsonReader.readObject(reader -> {
            boolean codeFound = false;
            String code = null;
            boolean messageFound = false;
            String message = null;
            List details = null;
            InnerError innererror = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ErrorDetail.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (codeFound && messageFound) {
                ErrorDetail deserializedErrorDetail = new ErrorDetail(code, message);
                deserializedErrorDetail.details = details;
                deserializedErrorDetail.innererror = innererror;
                return deserializedErrorDetail;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!codeFound) {
                missingProperties.add("code");
            }
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

