/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SnapshotFields;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class SnapshotSelector {
    private String nameFilter;
    private List<ConfigurationSnapshotStatus> status;
    private List<SnapshotFields> fields;

    public String getNameFilter() {
        return this.nameFilter;
    }

    public SnapshotSelector setNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
        return this;
    }

    public List<ConfigurationSnapshotStatus> getStatus() {
        return this.status;
    }

    public SnapshotSelector setStatus(ConfigurationSnapshotStatus ... status) {
        this.status = status == null ? null : Arrays.asList(status);
        return this;
    }

    public SnapshotSelector setStatus(List<ConfigurationSnapshotStatus> status) {
        this.status = status;
        return this;
    }

    public List<SnapshotFields> getFields() {
        return this.fields;
    }

    public SnapshotSelector setFields(SnapshotFields ... fields) {
        this.fields = fields == null ? null : Arrays.asList(fields);
        return this;
    }

    public SnapshotSelector setFields(List<SnapshotFields> fields) {
        this.fields = fields;
        return this;
    }

    public String toString() {
        String fields;
        if (CoreUtils.isNullOrEmpty(this.fields)) {
            fields = "ALL_FIELDS";
        } else {
            String string = fields = this.fields == null ? null : IterableStream.of(this.fields).stream().map(fieldsEnumValue -> fieldsEnumValue.toString()).collect(Collectors.joining(","));
        }
        String status = CoreUtils.isNullOrEmpty(this.status) ? "ALL_STATUS" : (this.status == null ? null : IterableStream.of(this.status).stream().map(statusEnumValue -> statusEnumValue.toString()).collect(Collectors.joining(",")));
        return "SnapshotSelector(name=" + this.nameFilter + ", status=" + status + ", fields=" + fields + ")";
    }
}

