// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.appconfiguration.implementation.models.CheckKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckKeyValuesHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckKeysHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckLabelsHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckRevisionsHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.CheckSnapshotsHeaders;
import com.azure.data.appconfiguration.implementation.models.CreateSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.DeleteKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.DeleteLockHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValuesHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValuesNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeysHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeysNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetLabelsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetLabelsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetRevisionsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetRevisionsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotsHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotsNextHeaders;
import com.azure.data.appconfiguration.implementation.models.Key;
import com.azure.data.appconfiguration.implementation.models.KeyListResult;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.implementation.models.KeyValueListResult;
import com.azure.data.appconfiguration.implementation.models.LabelListResult;
import com.azure.data.appconfiguration.implementation.models.OperationDetails;
import com.azure.data.appconfiguration.implementation.models.PutKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.PutLockHeaders;
import com.azure.data.appconfiguration.implementation.models.SnapshotListResult;
import com.azure.data.appconfiguration.implementation.models.SnapshotUpdateParameters;
import com.azure.data.appconfiguration.implementation.models.UpdateSnapshotHeaders;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SettingLabel;
import com.azure.data.appconfiguration.models.SettingLabelFields;
import com.azure.data.appconfiguration.models.SnapshotFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the AzureAppConfiguration type.
 */
public final class AzureAppConfigurationImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AzureAppConfigurationService service;

    /**
     * Used to guarantee real-time consistency between requests.
     */
    private final String syncToken;

    /**
     * Gets Used to guarantee real-time consistency between requests.
     * 
     * @return the syncToken value.
     */
    public String getSyncToken() {
        return this.syncToken;
    }

    /**
     * The endpoint of the App Configuration instance to send requests to.
     */
    private final String endpoint;

    /**
     * Gets The endpoint of the App Configuration instance to send requests to.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of AzureAppConfiguration client.
     * 
     * @param syncToken Used to guarantee real-time consistency between requests.
     * @param endpoint The endpoint of the App Configuration instance to send requests to.
     * @param apiVersion Api Version.
     */
    public AzureAppConfigurationImpl(String syncToken, String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), syncToken, endpoint, apiVersion);
    }

    /**
     * Initializes an instance of AzureAppConfiguration client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param syncToken Used to guarantee real-time consistency between requests.
     * @param endpoint The endpoint of the App Configuration instance to send requests to.
     * @param apiVersion Api Version.
     */
    public AzureAppConfigurationImpl(HttpPipeline httpPipeline, String syncToken, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), syncToken, endpoint, apiVersion);
    }

    /**
     * Initializes an instance of AzureAppConfiguration client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param syncToken Used to guarantee real-time consistency between requests.
     * @param endpoint The endpoint of the App Configuration instance to send requests to.
     * @param apiVersion Api Version.
     */
    public AzureAppConfigurationImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String syncToken,
        String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.syncToken = syncToken;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service
            = RestProxy.create(AzureAppConfigurationService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for AzureAppConfiguration to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureAppConfiguratio")
    public interface AzureAppConfigurationService {
        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetKeysHeaders, KeyListResult>> getKeys(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyListResult>> getKeysNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetKeysHeaders, KeyListResult> getKeysSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyListResult> getKeysNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("Accept") String accept,
            Context context);

        @Head("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeys(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, Context context);

        @Head("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkKeysNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, Context context);

        @Head("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckKeysHeaders, Void> checkKeysSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, Context context);

        @Head("/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkKeysNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, Context context);

        @Get("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetKeyValuesHeaders, KeyValueListResult>> getKeyValues(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValueListResult>> getKeyValuesNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetKeyValuesHeaders, KeyValueListResult> getKeyValuesSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValueListResult> getKeyValuesNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValues(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkKeyValuesNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckKeyValuesHeaders, Void> checkKeyValuesSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/kv")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkKeyValuesNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select, @QueryParam("snapshot") String snapshot,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Get("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValue(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValue>> getKeyValueNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetKeyValueHeaders, KeyValue> getKeyValueSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValue> getKeyValueNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValue(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") KeyValue entity, @HeaderParam("Accept") String accept, Context context);

        @Put("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValue>> putKeyValueNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") KeyValue entity, @HeaderParam("Accept") String accept, Context context);

        @Put("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<PutKeyValueHeaders, KeyValue> putKeyValueSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") KeyValue entity, @HeaderParam("Accept") String accept, Context context);

        @Put("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValue> putKeyValueNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") KeyValue entity, @HeaderParam("Accept") String accept, Context context);

        @Delete("/kv/{key}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValue(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("Accept") String accept, Context context);

        @Delete("/kv/{key}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValue>> deleteKeyValueNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("Accept") String accept, Context context);

        @Delete("/kv/{key}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<DeleteKeyValueHeaders, KeyValue> deleteKeyValueSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("Accept") String accept, Context context);

        @Delete("/kv/{key}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValue> deleteKeyValueNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("Accept") String accept, Context context);

        @Head("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValue(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select, Context context);

        @Head("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkKeyValueNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select, Context context);

        @Head("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckKeyValueHeaders, Void> checkKeyValueSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select, Context context);

        @Head("/kv/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkKeyValueNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select, Context context);

        @Get("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetSnapshotsHeaders, SnapshotListResult>> getSnapshots(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @QueryParam("$Select") String select, @QueryParam("status") String status,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SnapshotListResult>> getSnapshotsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @QueryParam("$Select") String select, @QueryParam("status") String status,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetSnapshotsHeaders, SnapshotListResult> getSnapshotsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @QueryParam("$Select") String select, @QueryParam("status") String status,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<SnapshotListResult> getSnapshotsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @QueryParam("$Select") String select, @QueryParam("status") String status,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshots(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, Context context);

        @Head("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkSnapshotsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, Context context);

        @Head("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckSnapshotsHeaders, Void> checkSnapshotsSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, Context context);

        @Head("/snapshots")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkSnapshotsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, Context context);

        @Get("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshot(
            @HostParam("endpoint") String endpoint, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @PathParam("name") String name,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam("$Select") String select, @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<ConfigurationSnapshot>> getSnapshotNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @PathParam("name") String name, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot> getSnapshotSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @PathParam("name") String name, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<ConfigurationSnapshot> getSnapshotNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @PathParam("name") String name, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/snapshots/{name}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshot(
            @HostParam("endpoint") String endpoint, @PathParam("name") String name,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ConfigurationSnapshot entity, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/snapshots/{name}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<ConfigurationSnapshot>> createSnapshotNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") ConfigurationSnapshot entity,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/snapshots/{name}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot> createSnapshotSync(
            @HostParam("endpoint") String endpoint, @PathParam("name") String name,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ConfigurationSnapshot entity, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/snapshots/{name}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<ConfigurationSnapshot> createSnapshotNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") ConfigurationSnapshot entity,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshot(
            @HostParam("endpoint") String endpoint, @PathParam("name") String name,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") SnapshotUpdateParameters entity, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<ConfigurationSnapshot>> updateSnapshotNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") SnapshotUpdateParameters entity, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot> updateSnapshotSync(
            @HostParam("endpoint") String endpoint, @PathParam("name") String name,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") SnapshotUpdateParameters entity, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<ConfigurationSnapshot> updateSnapshotNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch,
            @BodyParam("application/json") SnapshotUpdateParameters entity, @HeaderParam("Accept") String accept,
            Context context);

        @Head("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshot(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, Context context);

        @Head("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkSnapshotNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, Context context);

        @Head("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckSnapshotHeaders, Void> checkSnapshotSync(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, Context context);

        @Head("/snapshots/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkSnapshotNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, Context context);

        @Get("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetLabelsHeaders, LabelListResult>> getLabels(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<LabelListResult>> getLabelsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetLabelsHeaders, LabelListResult> getLabelsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<LabelListResult> getLabelsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabels(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            Context context);

        @Head("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkLabelsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            Context context);

        @Head("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckLabelsHeaders, Void> checkLabelsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            Context context);

        @Head("/labels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkLabelsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("name") String name, @HeaderParam("Sync-Token") String syncToken,
            @QueryParam("api-version") String apiVersion, @QueryParam("After") String after,
            @HeaderParam("Accept-Datetime") String acceptDatetime, @QueryParam("$Select") String select,
            Context context);

        @Put("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<PutLockHeaders, KeyValue>> putLock(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValue>> putLockNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<PutLockHeaders, KeyValue> putLockSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValue> putLockNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLock(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValue>> deleteLockNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<DeleteLockHeaders, KeyValue> deleteLockSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/locks/{key}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValue> deleteLockNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetRevisionsHeaders, KeyValueListResult>> getRevisions(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValueListResult>> getRevisionsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetRevisionsHeaders, KeyValueListResult> getRevisionsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValueListResult> getRevisionsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisions(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> checkRevisionsNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<CheckRevisionsHeaders, Void> checkRevisionsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Head("/revisions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> checkRevisionsNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("key") String key, @QueryParam("label") String label,
            @HeaderParam("Sync-Token") String syncToken, @QueryParam("api-version") String apiVersion,
            @QueryParam("After") String after, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @QueryParam("$Select") String select,
            @QueryParam(value = "tags", multipleQueryParams = true) List<String> tags, Context context);

        @Get("/operations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<OperationDetails>> getOperationDetails(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @QueryParam("snapshot") String snapshot,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/operations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<OperationDetails> getOperationDetailsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @QueryParam("snapshot") String snapshot,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetKeysNextHeaders, KeyListResult>> getKeysNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyListResult>> getKeysNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetKeysNextHeaders, KeyListResult> getKeysNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyListResult> getKeysNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult>> getKeyValuesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValueListResult>> getKeyValuesNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> getKeyValuesNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValueListResult> getKeyValuesNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult>> getSnapshotsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<SnapshotListResult>> getSnapshotsNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> getSnapshotsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<SnapshotListResult> getSnapshotsNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetLabelsNextHeaders, LabelListResult>> getLabelsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<LabelListResult>> getLabelsNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetLabelsNextHeaders, LabelListResult> getLabelsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<LabelListResult> getLabelsNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<GetRevisionsNextHeaders, KeyValueListResult>> getRevisionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<KeyValueListResult>> getRevisionsNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> getRevisionsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<KeyValueListResult> getRevisionsNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Sync-Token") String syncToken, @HeaderParam("Accept-Datetime") String acceptDatetime,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysSinglePageAsync(String name, String after, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(),
                after, acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysSinglePageAsync(String name, String after, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return service
            .getKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysAsync(String name, String after, String acceptDatetime) {
        return new PagedFlux<>(() -> getKeysSinglePageAsync(name, after, acceptDatetime),
            nextLink -> getKeysNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysAsync(String name, String after, String acceptDatetime, Context context) {
        return new PagedFlux<>(() -> getKeysSinglePageAsync(name, after, acceptDatetime, context),
            nextLink -> getKeysNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNoCustomHeadersSinglePageAsync(String name, String after,
        String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeysNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNoCustomHeadersSinglePageAsync(String name, String after,
        String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return service
            .getKeysNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysNoCustomHeadersAsync(String name, String after, String acceptDatetime) {
        return new PagedFlux<>(() -> getKeysNoCustomHeadersSinglePageAsync(name, after, acceptDatetime),
            nextLink -> getKeysNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<Key> getKeysNoCustomHeadersAsync(String name, String after, String acceptDatetime,
        Context context) {
        return new PagedFlux<>(() -> getKeysNoCustomHeadersSinglePageAsync(name, after, acceptDatetime, context),
            nextLink -> getKeysNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysSinglePage(String name, String after, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysHeaders, KeyListResult> res = service.getKeysSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysSinglePage(String name, String after, String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysHeaders, KeyListResult> res = service.getKeysSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<Key> getKeys(String name, String after, String acceptDatetime) {
        return new PagedIterable<>(() -> getKeysSinglePage(name, after, acceptDatetime, Context.NONE),
            nextLink -> getKeysNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<Key> getKeys(String name, String after, String acceptDatetime, Context context) {
        return new PagedIterable<>(() -> getKeysSinglePage(name, after, acceptDatetime, context),
            nextLink -> getKeysNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNoCustomHeadersSinglePage(String name, String after, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        Response<KeyListResult> res = service.getKeysNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNoCustomHeadersSinglePage(String name, String after, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        Response<KeyListResult> res = service.getKeysNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<Key> getKeysNoCustomHeaders(String name, String after, String acceptDatetime) {
        return new PagedIterable<>(() -> getKeysNoCustomHeadersSinglePage(name, after, acceptDatetime, Context.NONE),
            nextLink -> getKeysNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of keys.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<Key> getKeysNoCustomHeaders(String name, String after, String acceptDatetime,
        Context context) {
        return new PagedIterable<>(() -> getKeysNoCustomHeadersSinglePage(name, after, acceptDatetime, context),
            nextLink -> getKeysNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeysWithResponseAsync(String name, String after,
        String acceptDatetime) {
        return FluxUtil.withContext(context -> checkKeysWithResponseAsync(name, after, acceptDatetime, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeysHeaders, Void>> checkKeysWithResponseAsync(String name, String after,
        String acceptDatetime, Context context) {
        return service.checkKeys(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeysAsync(String name, String after, String acceptDatetime) {
        return checkKeysWithResponseAsync(name, after, acceptDatetime).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeysAsync(String name, String after, String acceptDatetime, Context context) {
        return checkKeysWithResponseAsync(name, after, acceptDatetime, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeysNoCustomHeadersWithResponseAsync(String name, String after,
        String acceptDatetime) {
        return FluxUtil
            .withContext(context -> checkKeysNoCustomHeadersWithResponseAsync(name, after, acceptDatetime, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeysNoCustomHeadersWithResponseAsync(String name, String after,
        String acceptDatetime, Context context) {
        return service.checkKeysNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(),
            after, acceptDatetime, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckKeysHeaders, Void> checkKeysWithResponse(String name, String after, String acceptDatetime,
        Context context) {
        return service.checkKeysSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkKeys(String name, String after, String acceptDatetime) {
        checkKeysWithResponse(name, after, acceptDatetime, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned keys.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkKeysNoCustomHeadersWithResponse(String name, String after, String acceptDatetime,
        Context context) {
        return service.checkKeysNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(),
            after, acceptDatetime, context);
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesSinglePageAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil
            .withContext(context -> service.getKeyValues(this.getEndpoint(), key, label, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch,
                tagsConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesSinglePageAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service
            .getKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags) {
        return new PagedFlux<>(() -> getKeyValuesSinglePageAsync(key, label, after, acceptDatetime, select, snapshot,
            ifMatch, ifNoneMatch, tags),
            nextLink -> getKeyValuesNextSinglePageAsync(nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags,
        Context context) {
        return new PagedFlux<>(
            () -> getKeyValuesSinglePageAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch,
                tags, context),
            nextLink -> getKeyValuesNextSinglePageAsync(nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNoCustomHeadersSinglePageAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch,
        String ifNoneMatch, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil
            .withContext(context -> service.getKeyValuesNoCustomHeaders(this.getEndpoint(), key, label,
                this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch,
                ifNoneMatch, tagsConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNoCustomHeadersSinglePageAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch,
        String ifNoneMatch, List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service
            .getKeyValuesNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
                after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesNoCustomHeadersAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags) {
        return new PagedFlux<>(
            () -> getKeyValuesNoCustomHeadersSinglePageAsync(key, label, after, acceptDatetime, select, snapshot,
                ifMatch, ifNoneMatch, tags),
            nextLink -> getKeyValuesNextSinglePageAsync(nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getKeyValuesNoCustomHeadersAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        return new PagedFlux<>(
            () -> getKeyValuesNoCustomHeadersSinglePageAsync(key, label, after, acceptDatetime, select, snapshot,
                ifMatch, ifNoneMatch, tags, context),
            nextLink -> getKeyValuesNextSinglePageAsync(nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesSinglePage(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ResponseBase<GetKeyValuesHeaders, KeyValueListResult> res
            = service.getKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesSinglePage(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ResponseBase<GetKeyValuesHeaders, KeyValueListResult> res
            = service.getKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValues(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags) {
        return new PagedIterable<>(
            () -> getKeyValuesSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch,
                tags, Context.NONE),
            nextLink -> getKeyValuesNextSinglePage(nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValues(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags,
        Context context) {
        return new PagedIterable<>(
            () -> getKeyValuesSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch,
                tags, context),
            nextLink -> getKeyValuesNextSinglePage(nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNoCustomHeadersSinglePage(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        Response<KeyValueListResult> res = service.getKeyValuesNoCustomHeadersSync(this.getEndpoint(), key, label,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch,
            ifNoneMatch, tagsConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNoCustomHeadersSinglePage(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        Response<KeyValueListResult> res = service.getKeyValuesNoCustomHeadersSync(this.getEndpoint(), key, label,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch,
            ifNoneMatch, tagsConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValuesNoCustomHeaders(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags) {
        return new PagedIterable<>(
            () -> getKeyValuesNoCustomHeadersSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch,
                ifNoneMatch, tags, Context.NONE),
            nextLink -> getKeyValuesNextSinglePage(nextLink, acceptDatetime, ifMatch, ifNoneMatch));
    }

    /**
     * Gets a list of key-values.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. The value should be the name of the snapshot. Not
     * valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-values as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getKeyValuesNoCustomHeaders(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        return new PagedIterable<>(
            () -> getKeyValuesNoCustomHeadersSinglePage(key, label, after, acceptDatetime, select, snapshot, ifMatch,
                ifNoneMatch, tags, context),
            nextLink -> getKeyValuesNextSinglePage(nextLink, acceptDatetime, ifMatch, ifNoneMatch, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValuesWithResponseAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch,
        String ifNoneMatch, List<String> tags) {
        return FluxUtil.withContext(context -> checkKeyValuesWithResponseAsync(key, label, after, acceptDatetime,
            select, snapshot, ifMatch, ifNoneMatch, tags, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValuesHeaders, Void>> checkKeyValuesWithResponseAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch,
        String ifNoneMatch, List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkKeyValues(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeyValuesAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags) {
        return checkKeyValuesWithResponseAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch,
            ifNoneMatch, tags).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeyValuesAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags,
        Context context) {
        return checkKeyValuesWithResponseAsync(key, label, after, acceptDatetime, select, snapshot, ifMatch,
            ifNoneMatch, tags, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeyValuesNoCustomHeadersWithResponseAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags) {
        return FluxUtil.withContext(context -> checkKeyValuesNoCustomHeadersWithResponseAsync(key, label, after,
            acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, tags, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeyValuesNoCustomHeadersWithResponseAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkKeyValuesNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted,
            context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckKeyValuesHeaders, Void> checkKeyValuesWithResponse(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkKeyValuesSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkKeyValues(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch, List<String> tags) {
        checkKeyValuesWithResponse(key, label, after, acceptDatetime, select, snapshot, ifMatch, ifNoneMatch, tags,
            Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param snapshot A filter used get key-values for a snapshot. Not valid when used with 'key' and 'label' filters.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/keyvaluefiltering.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkKeyValuesNoCustomHeadersWithResponse(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, String snapshot, String ifMatch, String ifNoneMatch,
        List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkKeyValuesNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, selectConverted, snapshot, ifMatch, ifNoneMatch, tagsConverted,
            context);
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValueWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return FluxUtil.withContext(
            context -> getKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, context));
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<GetKeyValueHeaders, KeyValue>> getKeyValueWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            acceptDatetime, ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> getKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch,
        String ifNoneMatch, List<SettingFields> select) {
        return getKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> getKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch,
        String ifNoneMatch, List<SettingFields> select, Context context) {
        return getKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> getKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return FluxUtil.withContext(context -> getKeyValueNoCustomHeadersWithResponseAsync(key, label, acceptDatetime,
            ifMatch, ifNoneMatch, select, context));
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> getKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getKeyValueNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<GetKeyValueHeaders, KeyValue> getKeyValueWithResponse(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            acceptDatetime, ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyValue getKeyValue(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch,
        List<SettingFields> select) {
        return getKeyValueWithResponse(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, Context.NONE)
            .getValue();
    }

    /**
     * Gets a single key-value.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyValue> getKeyValueNoCustomHeadersWithResponse(String key, String label, String acceptDatetime,
        String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getKeyValueNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValueWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, KeyValue entity) {
        return FluxUtil
            .withContext(context -> putKeyValueWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity, context));
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PutKeyValueHeaders, KeyValue>> putKeyValueWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, KeyValue entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, entity, accept, context);
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> putKeyValueAsync(String key, String label, String ifMatch, String ifNoneMatch,
        KeyValue entity) {
        return putKeyValueWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> putKeyValueAsync(String key, String label, String ifMatch, String ifNoneMatch,
        KeyValue entity, Context context) {
        return putKeyValueWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> putKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, KeyValue entity) {
        return FluxUtil.withContext(
            context -> putKeyValueNoCustomHeadersWithResponseAsync(key, label, ifMatch, ifNoneMatch, entity, context));
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> putKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, KeyValue entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putKeyValueNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, entity, accept, context);
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PutKeyValueHeaders, KeyValue> putKeyValueWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, KeyValue entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            ifMatch, ifNoneMatch, entity, accept, context);
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyValue putKeyValue(String key, String label, String ifMatch, String ifNoneMatch, KeyValue entity) {
        return putKeyValueWithResponse(key, label, ifMatch, ifNoneMatch, entity, Context.NONE).getValue();
    }

    /**
     * Creates a key-value.
     * 
     * @param key The key of the key-value to create.
     * @param label The label of the key-value to create.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param entity The key-value to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyValue> putKeyValueNoCustomHeadersWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, KeyValue entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putKeyValueNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, entity, accept, context);
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValueWithResponseAsync(String key, String label,
        String ifMatch) {
        return FluxUtil.withContext(context -> deleteKeyValueWithResponseAsync(key, label, ifMatch, context));
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteKeyValueHeaders, KeyValue>> deleteKeyValueWithResponseAsync(String key, String label,
        String ifMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            ifMatch, accept, context);
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> deleteKeyValueAsync(String key, String label, String ifMatch) {
        return deleteKeyValueWithResponseAsync(key, label, ifMatch).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> deleteKeyValueAsync(String key, String label, String ifMatch, Context context) {
        return deleteKeyValueWithResponseAsync(key, label, ifMatch, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> deleteKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String ifMatch) {
        return FluxUtil
            .withContext(context -> deleteKeyValueNoCustomHeadersWithResponseAsync(key, label, ifMatch, context));
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> deleteKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String ifMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteKeyValueNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, accept, context);
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DeleteKeyValueHeaders, KeyValue> deleteKeyValueWithResponse(String key, String label,
        String ifMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            ifMatch, accept, context);
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyValue deleteKeyValue(String key, String label, String ifMatch) {
        return deleteKeyValueWithResponse(key, label, ifMatch, Context.NONE).getValue();
    }

    /**
     * Deletes a key-value.
     * 
     * @param key The key of the key-value to delete.
     * @param label The label of the key-value to delete.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyValue> deleteKeyValueNoCustomHeadersWithResponse(String key, String label, String ifMatch,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteKeyValueNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, accept, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValueWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return FluxUtil.withContext(context -> checkKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch,
            ifNoneMatch, select, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckKeyValueHeaders, Void>> checkKeyValueWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkKeyValue(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch,
        String ifNoneMatch, List<SettingFields> select) {
        return checkKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkKeyValueAsync(String key, String label, String acceptDatetime, String ifMatch,
        String ifNoneMatch, List<SettingFields> select, Context context) {
        return checkKeyValueWithResponseAsync(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select) {
        return FluxUtil.withContext(context -> checkKeyValueNoCustomHeadersWithResponseAsync(key, label, acceptDatetime,
            ifMatch, ifNoneMatch, select, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkKeyValueNoCustomHeadersWithResponseAsync(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkKeyValueNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckKeyValueHeaders, Void> checkKeyValueWithResponse(String key, String label,
        String acceptDatetime, String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkKeyValueSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkKeyValue(String key, String label, String acceptDatetime, String ifMatch, String ifNoneMatch,
        List<SettingFields> select) {
        checkKeyValueWithResponse(key, label, acceptDatetime, ifMatch, ifNoneMatch, select, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key The key of the key-value to retrieve.
     * @param label The label of the key-value to retrieve.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkKeyValueNoCustomHeadersWithResponse(String key, String label, String acceptDatetime,
        String ifMatch, String ifNoneMatch, List<SettingFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkKeyValueNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), acceptDatetime, ifMatch, ifNoneMatch, selectConverted, context);
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsSinglePageAsync(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getSnapshots(this.getEndpoint(), name, this.getSyncToken(),
                this.getApiVersion(), after, selectConverted, statusConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsSinglePageAsync(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .getSnapshots(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, selectConverted,
                statusConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsAsync(String name, String after, List<SnapshotFields> select,
        List<ConfigurationSnapshotStatus> status) {
        return new PagedFlux<>(() -> getSnapshotsSinglePageAsync(name, after, select, status),
            nextLink -> getSnapshotsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsAsync(String name, String after, List<SnapshotFields> select,
        List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedFlux<>(() -> getSnapshotsSinglePageAsync(name, after, select, status, context),
            nextLink -> getSnapshotsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNoCustomHeadersSinglePageAsync(String name,
        String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getSnapshotsNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(),
                this.getApiVersion(), after, selectConverted, statusConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNoCustomHeadersSinglePageAsync(String name,
        String after, List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .getSnapshotsNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
                selectConverted, statusConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsNoCustomHeadersAsync(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        return new PagedFlux<>(() -> getSnapshotsNoCustomHeadersSinglePageAsync(name, after, select, status),
            nextLink -> getSnapshotsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSnapshot> getSnapshotsNoCustomHeadersAsync(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedFlux<>(() -> getSnapshotsNoCustomHeadersSinglePageAsync(name, after, select, status, context),
            nextLink -> getSnapshotsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsSinglePage(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        ResponseBase<GetSnapshotsHeaders, SnapshotListResult> res = service.getSnapshotsSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsSinglePage(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        ResponseBase<GetSnapshotsHeaders, SnapshotListResult> res = service.getSnapshotsSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshots(String name, String after, List<SnapshotFields> select,
        List<ConfigurationSnapshotStatus> status) {
        return new PagedIterable<>(() -> getSnapshotsSinglePage(name, after, select, status, Context.NONE),
            nextLink -> getSnapshotsNextSinglePage(nextLink));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshots(String name, String after, List<SnapshotFields> select,
        List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedIterable<>(() -> getSnapshotsSinglePage(name, after, select, status, context),
            nextLink -> getSnapshotsNextSinglePage(nextLink, context));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNoCustomHeadersSinglePage(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        Response<SnapshotListResult> res = service.getSnapshotsNoCustomHeadersSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNoCustomHeadersSinglePage(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        String statusConverted = (status == null)
            ? null
            : status.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        Response<SnapshotListResult> res = service.getSnapshotsNoCustomHeadersSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, selectConverted, statusConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshotsNoCustomHeaders(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status) {
        return new PagedIterable<>(
            () -> getSnapshotsNoCustomHeadersSinglePage(name, after, select, status, Context.NONE),
            nextLink -> getSnapshotsNextSinglePage(nextLink));
    }

    /**
     * Gets a list of key-value snapshots.
     * 
     * @param name A filter for the name of the returned snapshots.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param status Used to filter returned snapshots by their status property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value snapshots as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> getSnapshotsNoCustomHeaders(String name, String after,
        List<SnapshotFields> select, List<ConfigurationSnapshotStatus> status, Context context) {
        return new PagedIterable<>(() -> getSnapshotsNoCustomHeadersSinglePage(name, after, select, status, context),
            nextLink -> getSnapshotsNextSinglePage(nextLink, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshotsWithResponseAsync(String after) {
        return FluxUtil.withContext(context -> checkSnapshotsWithResponseAsync(after, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotsHeaders, Void>> checkSnapshotsWithResponseAsync(String after,
        Context context) {
        return service.checkSnapshots(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), after, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkSnapshotsAsync(String after) {
        return checkSnapshotsWithResponseAsync(after).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkSnapshotsAsync(String after, Context context) {
        return checkSnapshotsWithResponseAsync(after, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkSnapshotsNoCustomHeadersWithResponseAsync(String after) {
        return FluxUtil.withContext(context -> checkSnapshotsNoCustomHeadersWithResponseAsync(after, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkSnapshotsNoCustomHeadersWithResponseAsync(String after, Context context) {
        return service.checkSnapshotsNoCustomHeaders(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(),
            after, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckSnapshotsHeaders, Void> checkSnapshotsWithResponse(String after, Context context) {
        return service.checkSnapshotsSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), after,
            context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkSnapshots(String after) {
        checkSnapshotsWithResponse(after, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkSnapshotsNoCustomHeadersWithResponse(String after, Context context) {
        return service.checkSnapshotsNoCustomHeadersSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(),
            after, context);
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshotWithResponseAsync(String name,
        String ifMatch, String ifNoneMatch, List<SnapshotFields> select) {
        return FluxUtil
            .withContext(context -> getSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, select, context));
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot>> getSnapshotWithResponseAsync(String name,
        String ifMatch, String ifNoneMatch, List<SnapshotFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getSnapshot(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name, ifMatch,
            ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> getSnapshotAsync(String name, String ifMatch, String ifNoneMatch,
        List<SnapshotFields> select) {
        return getSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, select)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> getSnapshotAsync(String name, String ifMatch, String ifNoneMatch,
        List<SnapshotFields> select, Context context) {
        return getSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, select, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> getSnapshotNoCustomHeadersWithResponseAsync(String name,
        String ifMatch, String ifNoneMatch, List<SnapshotFields> select) {
        return FluxUtil.withContext(
            context -> getSnapshotNoCustomHeadersWithResponseAsync(name, ifMatch, ifNoneMatch, select, context));
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> getSnapshotNoCustomHeadersWithResponseAsync(String name,
        String ifMatch, String ifNoneMatch, List<SnapshotFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getSnapshotNoCustomHeaders(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name,
            ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot> getSnapshotWithResponse(String name, String ifMatch,
        String ifNoneMatch, List<SnapshotFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getSnapshotSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(), name, ifMatch,
            ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConfigurationSnapshot getSnapshot(String name, String ifMatch, String ifNoneMatch,
        List<SnapshotFields> select) {
        return getSnapshotWithResponse(name, ifMatch, ifNoneMatch, select, Context.NONE).getValue();
    }

    /**
     * Gets a single key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to retrieve.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single key-value snapshot along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> getSnapshotNoCustomHeadersWithResponse(String name, String ifMatch,
        String ifNoneMatch, List<SnapshotFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.getSnapshotNoCustomHeadersSync(this.getEndpoint(), this.getSyncToken(), this.getApiVersion(),
            name, ifMatch, ifNoneMatch, selectConverted, accept, context);
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshotWithResponseAsync(String name,
        ConfigurationSnapshot entity) {
        return FluxUtil.withContext(context -> createSnapshotWithResponseAsync(name, entity, context));
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot>> createSnapshotWithResponseAsync(String name,
        ConfigurationSnapshot entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.createSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), entity,
            accept, context);
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> createSnapshotAsync(String name, ConfigurationSnapshot entity) {
        return createSnapshotWithResponseAsync(name, entity).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> createSnapshotAsync(String name, ConfigurationSnapshot entity, Context context) {
        return createSnapshotWithResponseAsync(name, entity, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> createSnapshotNoCustomHeadersWithResponseAsync(String name,
        ConfigurationSnapshot entity) {
        return FluxUtil.withContext(context -> createSnapshotNoCustomHeadersWithResponseAsync(name, entity, context));
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> createSnapshotNoCustomHeadersWithResponseAsync(String name,
        ConfigurationSnapshot entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.createSnapshotNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), entity, accept, context);
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot> createSnapshotWithResponse(String name,
        ConfigurationSnapshot entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.createSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), entity,
            accept, context);
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConfigurationSnapshot createSnapshot(String name, ConfigurationSnapshot entity) {
        return createSnapshotWithResponse(name, entity, Context.NONE).getValue();
    }

    /**
     * Creates a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to create.
     * @param entity The key-value snapshot to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> createSnapshotNoCustomHeadersWithResponse(String name,
        ConfigurationSnapshot entity, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.createSnapshotNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), entity, accept, context);
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshotWithResponseAsync(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch) {
        return FluxUtil
            .withContext(context -> updateSnapshotWithResponseAsync(name, entity, ifMatch, ifNoneMatch, context));
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot>> updateSnapshotWithResponseAsync(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.updateSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, entity, accept, context);
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> updateSnapshotAsync(String name, SnapshotUpdateParameters entity, String ifMatch,
        String ifNoneMatch) {
        return updateSnapshotWithResponseAsync(name, entity, ifMatch, ifNoneMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConfigurationSnapshot> updateSnapshotAsync(String name, SnapshotUpdateParameters entity, String ifMatch,
        String ifNoneMatch, Context context) {
        return updateSnapshotWithResponseAsync(name, entity, ifMatch, ifNoneMatch, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> updateSnapshotNoCustomHeadersWithResponseAsync(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch) {
        return FluxUtil.withContext(
            context -> updateSnapshotNoCustomHeadersWithResponseAsync(name, entity, ifMatch, ifNoneMatch, context));
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConfigurationSnapshot>> updateSnapshotNoCustomHeadersWithResponseAsync(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.updateSnapshotNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, entity, accept, context);
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<UpdateSnapshotHeaders, ConfigurationSnapshot> updateSnapshotWithResponse(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.updateSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, entity, accept, context);
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConfigurationSnapshot updateSnapshot(String name, SnapshotUpdateParameters entity, String ifMatch,
        String ifNoneMatch) {
        return updateSnapshotWithResponse(name, entity, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    /**
     * Updates the state of a key-value snapshot.
     * 
     * @param name The name of the key-value snapshot to update.
     * @param entity The parameters used to update the snapshot.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> updateSnapshotNoCustomHeadersWithResponse(String name,
        SnapshotUpdateParameters entity, String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshot+json, application/problem+json";
        return service.updateSnapshotNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, entity, accept, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshotWithResponseAsync(String name, String ifMatch,
        String ifNoneMatch) {
        return FluxUtil.withContext(context -> checkSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckSnapshotHeaders, Void>> checkSnapshotWithResponseAsync(String name, String ifMatch,
        String ifNoneMatch, Context context) {
        return service.checkSnapshot(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkSnapshotAsync(String name, String ifMatch, String ifNoneMatch) {
        return checkSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkSnapshotAsync(String name, String ifMatch, String ifNoneMatch, Context context) {
        return checkSnapshotWithResponseAsync(name, ifMatch, ifNoneMatch, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkSnapshotNoCustomHeadersWithResponseAsync(String name, String ifMatch,
        String ifNoneMatch) {
        return FluxUtil
            .withContext(context -> checkSnapshotNoCustomHeadersWithResponseAsync(name, ifMatch, ifNoneMatch, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkSnapshotNoCustomHeadersWithResponseAsync(String name, String ifMatch,
        String ifNoneMatch, Context context) {
        return service.checkSnapshotNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(),
            ifMatch, ifNoneMatch, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckSnapshotHeaders, Void> checkSnapshotWithResponse(String name, String ifMatch,
        String ifNoneMatch, Context context) {
        return service.checkSnapshotSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkSnapshot(String name, String ifMatch, String ifNoneMatch) {
        checkSnapshotWithResponse(name, ifMatch, ifNoneMatch, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name The name of the key-value snapshot to check.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkSnapshotNoCustomHeadersWithResponse(String name, String ifMatch, String ifNoneMatch,
        Context context) {
        return service.checkSnapshotNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, context);
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsSinglePageAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getLabels(this.getEndpoint(), name, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsSinglePageAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .getLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after, acceptDatetime,
                selectConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SettingLabel> getLabelsAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        return new PagedFlux<>(() -> getLabelsSinglePageAsync(name, after, acceptDatetime, select),
            nextLink -> getLabelsNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SettingLabel> getLabelsAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        return new PagedFlux<>(() -> getLabelsSinglePageAsync(name, after, acceptDatetime, select, context),
            nextLink -> getLabelsNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNoCustomHeadersSinglePageAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.getLabelsNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNoCustomHeadersSinglePageAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .getLabelsNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SettingLabel> getLabelsNoCustomHeadersAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        return new PagedFlux<>(() -> getLabelsNoCustomHeadersSinglePageAsync(name, after, acceptDatetime, select),
            nextLink -> getLabelsNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SettingLabel> getLabelsNoCustomHeadersAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        return new PagedFlux<>(
            () -> getLabelsNoCustomHeadersSinglePageAsync(name, after, acceptDatetime, select, context),
            nextLink -> getLabelsNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsSinglePage(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        ResponseBase<GetLabelsHeaders, LabelListResult> res = service.getLabelsSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsSinglePage(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        ResponseBase<GetLabelsHeaders, LabelListResult> res = service.getLabelsSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> getLabels(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        return new PagedIterable<>(() -> getLabelsSinglePage(name, after, acceptDatetime, select, Context.NONE),
            nextLink -> getLabelsNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> getLabels(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        return new PagedIterable<>(() -> getLabelsSinglePage(name, after, acceptDatetime, select, context),
            nextLink -> getLabelsNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNoCustomHeadersSinglePage(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        Response<LabelListResult> res = service.getLabelsNoCustomHeadersSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNoCustomHeadersSinglePage(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        Response<LabelListResult> res = service.getLabelsNoCustomHeadersSync(this.getEndpoint(), name,
            this.getSyncToken(), this.getApiVersion(), after, acceptDatetime, selectConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> getLabelsNoCustomHeaders(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        return new PagedIterable<>(
            () -> getLabelsNoCustomHeadersSinglePage(name, after, acceptDatetime, select, Context.NONE),
            nextLink -> getLabelsNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of labels.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of labels as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> getLabelsNoCustomHeaders(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        return new PagedIterable<>(
            () -> getLabelsNoCustomHeadersSinglePage(name, after, acceptDatetime, select, context),
            nextLink -> getLabelsNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabelsWithResponseAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select) {
        return FluxUtil
            .withContext(context -> checkLabelsWithResponseAsync(name, after, acceptDatetime, select, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckLabelsHeaders, Void>> checkLabelsWithResponseAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkLabels(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkLabelsAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select) {
        return checkLabelsWithResponseAsync(name, after, acceptDatetime, select).flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkLabelsAsync(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        return checkLabelsWithResponseAsync(name, after, acceptDatetime, select, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkLabelsNoCustomHeadersWithResponseAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select) {
        return FluxUtil.withContext(
            context -> checkLabelsNoCustomHeadersWithResponseAsync(name, after, acceptDatetime, select, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkLabelsNoCustomHeadersWithResponseAsync(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkLabelsNoCustomHeaders(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(),
            after, acceptDatetime, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckLabelsHeaders, Void> checkLabelsWithResponse(String name, String after,
        String acceptDatetime, List<SettingLabelFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkLabelsSync(this.getEndpoint(), name, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, selectConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkLabels(String name, String after, String acceptDatetime, List<SettingLabelFields> select) {
        checkLabelsWithResponse(name, after, acceptDatetime, select, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param name A filter for the name of the returned labels.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkLabelsNoCustomHeadersWithResponse(String name, String after, String acceptDatetime,
        List<SettingLabelFields> select, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.checkLabelsNoCustomHeadersSync(this.getEndpoint(), name, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, selectConverted, context);
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PutLockHeaders, KeyValue>> putLockWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch) {
        return FluxUtil.withContext(context -> putLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context));
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PutLockHeaders, KeyValue>> putLockWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, accept, context);
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> putLockAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        return putLockWithResponseAsync(key, label, ifMatch, ifNoneMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> putLockAsync(String key, String label, String ifMatch, String ifNoneMatch, Context context) {
        return putLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> putLockNoCustomHeadersWithResponseAsync(String key, String label, String ifMatch,
        String ifNoneMatch) {
        return FluxUtil
            .withContext(context -> putLockNoCustomHeadersWithResponseAsync(key, label, ifMatch, ifNoneMatch, context));
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> putLockNoCustomHeadersWithResponseAsync(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putLockNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            ifMatch, ifNoneMatch, accept, context);
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PutLockHeaders, KeyValue> putLockWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putLockSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, accept, context);
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyValue putLock(String key, String label, String ifMatch, String ifNoneMatch) {
        return putLockWithResponse(key, label, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    /**
     * Locks a key-value.
     * 
     * @param key The key of the key-value to lock.
     * @param label The label, if any, of the key-value to lock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyValue> putLockNoCustomHeadersWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.putLockNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, accept, context);
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLockWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch) {
        return FluxUtil.withContext(context -> deleteLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context));
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DeleteLockHeaders, KeyValue>> deleteLockWithResponseAsync(String key, String label,
        String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteLock(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), ifMatch,
            ifNoneMatch, accept, context);
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> deleteLockAsync(String key, String label, String ifMatch, String ifNoneMatch) {
        return deleteLockWithResponseAsync(key, label, ifMatch, ifNoneMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyValue> deleteLockAsync(String key, String label, String ifMatch, String ifNoneMatch,
        Context context) {
        return deleteLockWithResponseAsync(key, label, ifMatch, ifNoneMatch, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> deleteLockNoCustomHeadersWithResponseAsync(String key, String label, String ifMatch,
        String ifNoneMatch) {
        return FluxUtil.withContext(
            context -> deleteLockNoCustomHeadersWithResponseAsync(key, label, ifMatch, ifNoneMatch, context));
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyValue>> deleteLockNoCustomHeadersWithResponseAsync(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteLockNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, accept, context);
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DeleteLockHeaders, KeyValue> deleteLockWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteLockSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            ifMatch, ifNoneMatch, accept, context);
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyValue deleteLock(String key, String label, String ifMatch, String ifNoneMatch) {
        return deleteLockWithResponse(key, label, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    /**
     * Unlocks a key-value.
     * 
     * @param key The key of the key-value to unlock.
     * @param label The label, if any, of the key-value to unlock.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyValue> deleteLockNoCustomHeadersWithResponse(String key, String label, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kv+json, application/problem+json";
        return service.deleteLockNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), ifMatch, ifNoneMatch, accept, context);
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsSinglePageAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil
            .withContext(context -> service.getRevisions(this.getEndpoint(), key, label, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsSinglePageAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service
            .getRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, tagsConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags) {
        return new PagedFlux<>(() -> getRevisionsSinglePageAsync(key, label, after, acceptDatetime, select, tags),
            nextLink -> getRevisionsNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags, Context context) {
        return new PagedFlux<>(
            () -> getRevisionsSinglePageAsync(key, label, after, acceptDatetime, select, tags, context),
            nextLink -> getRevisionsNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNoCustomHeadersSinglePageAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil
            .withContext(
                context -> service.getRevisionsNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
                    this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNoCustomHeadersSinglePageAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service
            .getRevisionsNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
                after, acceptDatetime, selectConverted, tagsConverted, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsNoCustomHeadersAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags) {
        return new PagedFlux<>(
            () -> getRevisionsNoCustomHeadersSinglePageAsync(key, label, after, acceptDatetime, select, tags),
            nextLink -> getRevisionsNextSinglePageAsync(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyValue> getRevisionsNoCustomHeadersAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        return new PagedFlux<>(
            () -> getRevisionsNoCustomHeadersSinglePageAsync(key, label, after, acceptDatetime, select, tags, context),
            nextLink -> getRevisionsNextSinglePageAsync(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsSinglePage(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ResponseBase<GetRevisionsHeaders, KeyValueListResult> res
            = service.getRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, tagsConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsSinglePage(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        ResponseBase<GetRevisionsHeaders, KeyValueListResult> res
            = service.getRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
                acceptDatetime, selectConverted, tagsConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisions(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags) {
        return new PagedIterable<>(
            () -> getRevisionsSinglePage(key, label, after, acceptDatetime, select, tags, Context.NONE),
            nextLink -> getRevisionsNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisions(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags, Context context) {
        return new PagedIterable<>(
            () -> getRevisionsSinglePage(key, label, after, acceptDatetime, select, tags, context),
            nextLink -> getRevisionsNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNoCustomHeadersSinglePage(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        Response<KeyValueListResult> res
            = service.getRevisionsNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNoCustomHeadersSinglePage(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        Response<KeyValueListResult> res
            = service.getRevisionsNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
                this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisionsNoCustomHeaders(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags) {
        return new PagedIterable<>(
            () -> getRevisionsNoCustomHeadersSinglePage(key, label, after, acceptDatetime, select, tags, Context.NONE),
            nextLink -> getRevisionsNextSinglePage(nextLink, acceptDatetime));
    }

    /**
     * Gets a list of key-value revisions.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of key-value revisions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyValue> getRevisionsNoCustomHeaders(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        return new PagedIterable<>(
            () -> getRevisionsNoCustomHeadersSinglePage(key, label, after, acceptDatetime, select, tags, context),
            nextLink -> getRevisionsNextSinglePage(nextLink, acceptDatetime, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisionsWithResponseAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, List<String> tags) {
        return FluxUtil.withContext(
            context -> checkRevisionsWithResponseAsync(key, label, after, acceptDatetime, select, tags, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CheckRevisionsHeaders, Void>> checkRevisionsWithResponseAsync(String key, String label,
        String after, String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkRevisions(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(), after,
            acceptDatetime, selectConverted, tagsConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkRevisionsAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags) {
        return checkRevisionsWithResponseAsync(key, label, after, acceptDatetime, select, tags)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkRevisionsAsync(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags, Context context) {
        return checkRevisionsWithResponseAsync(key, label, after, acceptDatetime, select, tags, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkRevisionsNoCustomHeadersWithResponseAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags) {
        return FluxUtil.withContext(context -> checkRevisionsNoCustomHeadersWithResponseAsync(key, label, after,
            acceptDatetime, select, tags, context));
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkRevisionsNoCustomHeadersWithResponseAsync(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkRevisionsNoCustomHeaders(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CheckRevisionsHeaders, Void> checkRevisionsWithResponse(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkRevisionsSync(this.getEndpoint(), key, label, this.getSyncToken(), this.getApiVersion(),
            after, acceptDatetime, selectConverted, tagsConverted, context);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkRevisions(String key, String label, String after, String acceptDatetime,
        List<SettingFields> select, List<String> tags) {
        checkRevisionsWithResponse(key, label, after, acceptDatetime, select, tags, Context.NONE);
    }

    /**
     * Requests the headers and status of the given resource.
     * 
     * @param key A filter used to match keys. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param label A filter used to match labels. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param after Instructs the server to return elements that appear after the element referred to by the specified
     * token.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param select Used to select what fields are present in the returned resource(s).
     * @param tags A filter used to query by tags. Syntax reference: https://aka.ms/azconfig/docs/restapirevisions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkRevisionsNoCustomHeadersWithResponse(String key, String label, String after,
        String acceptDatetime, List<SettingFields> select, List<String> tags, Context context) {
        String selectConverted = (select == null)
            ? null
            : select.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        List<String> tagsConverted = (tags == null)
            ? new ArrayList<>()
            : tags.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return service.checkRevisionsNoCustomHeadersSync(this.getEndpoint(), key, label, this.getSyncToken(),
            this.getApiVersion(), after, acceptDatetime, selectConverted, tagsConverted, context);
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationDetailsWithResponseAsync(String snapshot) {
        return FluxUtil.withContext(context -> getOperationDetailsWithResponseAsync(snapshot, context));
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationDetailsWithResponseAsync(String snapshot, Context context) {
        final String accept = "application/json";
        return service.getOperationDetails(this.getEndpoint(), this.getApiVersion(), snapshot, accept, context);
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationDetailsAsync(String snapshot) {
        return getOperationDetailsWithResponseAsync(snapshot).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationDetailsAsync(String snapshot, Context context) {
        return getOperationDetailsWithResponseAsync(snapshot, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OperationDetails> getOperationDetailsWithResponse(String snapshot, Context context) {
        final String accept = "application/json";
        return service.getOperationDetailsSync(this.getEndpoint(), this.getApiVersion(), snapshot, accept, context);
    }

    /**
     * Gets the state of a long running operation.
     * 
     * @param snapshot Snapshot identifier for the long running operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the state of a long running operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationDetails getOperationDetails(String snapshot) {
        return getOperationDetailsWithResponse(snapshot, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextSinglePageAsync(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeysNext(nextLink, this.getEndpoint(), this.getSyncToken(),
                acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextSinglePageAsync(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return service.getKeysNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextNoCustomHeadersSinglePageAsync(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeysNextNoCustomHeaders(nextLink, this.getEndpoint(),
                this.getSyncToken(), acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<Key>> getKeysNextNoCustomHeadersSinglePageAsync(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        return service
            .getKeysNextNoCustomHeaders(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysNextHeaders, KeyListResult> res = service.getKeysNextSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextSinglePage(String nextLink, String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        ResponseBase<GetKeysNextHeaders, KeyListResult> res = service.getKeysNextSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        Response<KeyListResult> res = service.getKeysNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<Key> getKeysNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.keyset+json, application/problem+json";
        Response<KeyListResult> res = service.getKeysNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextSinglePageAsync(String nextLink, String acceptDatetime,
        String ifMatch, String ifNoneMatch) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeyValuesNext(nextLink, this.getEndpoint(), this.getSyncToken(),
                acceptDatetime, ifMatch, ifNoneMatch, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextSinglePageAsync(String nextLink, String acceptDatetime,
        String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return service
            .getKeyValuesNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch,
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime, String ifMatch, String ifNoneMatch) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getKeyValuesNextNoCustomHeaders(nextLink, this.getEndpoint(),
                this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getKeyValuesNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime, String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return service
            .getKeyValuesNextNoCustomHeaders(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch,
                ifNoneMatch, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextSinglePage(String nextLink, String acceptDatetime, String ifMatch,
        String ifNoneMatch) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> res = service.getKeyValuesNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextSinglePage(String nextLink, String acceptDatetime, String ifMatch,
        String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetKeyValuesNextHeaders, KeyValueListResult> res = service.getKeyValuesNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime,
        String ifMatch, String ifNoneMatch) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        Response<KeyValueListResult> res = service.getKeyValuesNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param ifMatch Used to perform an operation only if the targeted resource's etag matches the value provided.
     * @param ifNoneMatch Used to perform an operation only if the targeted resource's etag does not match the value
     * provided.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getKeyValuesNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime,
        String ifMatch, String ifNoneMatch, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        Response<KeyValueListResult> res = service.getKeyValuesNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, ifMatch, ifNoneMatch, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextSinglePageAsync(String nextLink) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return FluxUtil
            .withContext(
                context -> service.getSnapshotsNext(nextLink, this.getEndpoint(), this.getSyncToken(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return service.getSnapshotsNext(nextLink, this.getEndpoint(), this.getSyncToken(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextNoCustomHeadersSinglePageAsync(String nextLink) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getSnapshotsNextNoCustomHeaders(nextLink, this.getEndpoint(),
                this.getSyncToken(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ConfigurationSnapshot>> getSnapshotsNextNoCustomHeadersSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        return service
            .getSnapshotsNextNoCustomHeaders(nextLink, this.getEndpoint(), this.getSyncToken(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextSinglePage(String nextLink) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> res
            = service.getSnapshotsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        ResponseBase<GetSnapshotsNextHeaders, SnapshotListResult> res
            = service.getSnapshotsNextSync(nextLink, this.getEndpoint(), this.getSyncToken(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextNoCustomHeadersSinglePage(String nextLink) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        Response<SnapshotListResult> res = service.getSnapshotsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a snapshot list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ConfigurationSnapshot> getSnapshotsNextNoCustomHeadersSinglePage(String nextLink,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json";
        Response<SnapshotListResult> res = service.getSnapshotsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNextSinglePageAsync(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getLabelsNext(nextLink, this.getEndpoint(), this.getSyncToken(),
                acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNextSinglePageAsync(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return service.getLabelsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getLabelsNextNoCustomHeaders(nextLink, this.getEndpoint(),
                this.getSyncToken(), acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SettingLabel>> getLabelsNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        return service
            .getLabelsNextNoCustomHeaders(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNextSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        ResponseBase<GetLabelsNextHeaders, LabelListResult> res = service.getLabelsNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNextSinglePage(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        ResponseBase<GetLabelsNextHeaders, LabelListResult> res = service.getLabelsNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        Response<LabelListResult> res = service.getLabelsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SettingLabel> getLabelsNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.labelset+json, application/problem+json";
        Response<LabelListResult> res = service.getLabelsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextSinglePageAsync(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getRevisionsNext(nextLink, this.getEndpoint(), this.getSyncToken(),
                acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextSinglePageAsync(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return service
            .getRevisionsNext(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return FluxUtil
            .withContext(context -> service.getRevisionsNextNoCustomHeaders(nextLink, this.getEndpoint(),
                this.getSyncToken(), acceptDatetime, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KeyValue>> getRevisionsNextNoCustomHeadersSinglePageAsync(String nextLink,
        String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        return service
            .getRevisionsNextNoCustomHeaders(nextLink, this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getItems(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> res = service.getRevisionsNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextSinglePage(String nextLink, String acceptDatetime, Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        ResponseBase<GetRevisionsNextHeaders, KeyValueListResult> res = service.getRevisionsNextSync(nextLink,
            this.getEndpoint(), this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        Response<KeyValueListResult> res = service.getRevisionsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptDatetime Requests the server to respond with the state of the resource at the specified time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a list request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KeyValue> getRevisionsNextNoCustomHeadersSinglePage(String nextLink, String acceptDatetime,
        Context context) {
        final String accept = "application/vnd.microsoft.appconfig.kvset+json, application/problem+json";
        Response<KeyValueListResult> res = service.getRevisionsNextNoCustomHeadersSync(nextLink, this.getEndpoint(),
            this.getSyncToken(), acceptDatetime, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getItems(), res.getValue().getNextLink(), null);
    }
}
