/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.experimental.models.MessageWithMetadata;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.apacheavro.AvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroException;
import com.azure.data.schemaregistry.apacheavro.SerializerOptions;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.avro.Schema;
import reactor.core.publisher.Mono;

public final class SchemaRegistryApacheAvroSerializer {
    static final String AVRO_MIME_TYPE = "avro/binary";
    static final byte[] RECORD_FORMAT_INDICATOR = new byte[]{0, 0, 0, 0};
    static final int RECORD_FORMAT_INDICATOR_SIZE = RECORD_FORMAT_INDICATOR.length;
    static final int SCHEMA_ID_SIZE = 32;
    private final ClientLogger logger = new ClientLogger(SchemaRegistryApacheAvroSerializer.class);
    private final SchemaRegistryAsyncClient schemaRegistryClient;
    private final AvroSerializer avroSerializer;
    private final SerializerOptions serializerOptions;

    SchemaRegistryApacheAvroSerializer(SchemaRegistryAsyncClient schemaRegistryClient, AvroSerializer avroSerializer, SerializerOptions serializerOptions) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "'schemaRegistryClient' cannot be null.");
        this.avroSerializer = Objects.requireNonNull(avroSerializer, "'avroSerializer' cannot be null.");
        this.serializerOptions = Objects.requireNonNull(serializerOptions, "'serializerOptions' cannot be null.");
    }

    public <T extends MessageWithMetadata> T serializeMessageData(Object object, TypeReference<T> typeReference) {
        return (T)((MessageWithMetadata)this.serializeMessageDataAsync(object, typeReference).block());
    }

    public <T extends MessageWithMetadata> T serializeMessageData(Object object, TypeReference<T> typeReference, Function<BinaryData, T> messageFactory) {
        return (T)((MessageWithMetadata)this.serializeMessageDataAsync(object, typeReference, messageFactory).block());
    }

    public <T extends MessageWithMetadata> Mono<T> serializeMessageDataAsync(Object object, TypeReference<T> typeReference) {
        return this.serializeMessageDataAsync(object, typeReference, null);
    }

    public <T extends MessageWithMetadata> Mono<T> serializeMessageDataAsync(Object object, TypeReference<T> typeReference, Function<BinaryData, T> messageFactory) {
        Schema schema;
        if (object == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("Null object, behavior should be defined in concrete serializer implementation."));
        }
        if (typeReference == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'typeReference' cannot be null."));
        }
        Optional<Constructor> constructor = Arrays.stream(typeReference.getJavaClass().getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent() && messageFactory == null) {
            return Mono.error((Throwable)new IllegalArgumentException(typeReference.getJavaClass() + "does not have have a no-arg constructor to create a new instance of T with. Use the overload that accepts 'messageFactory'."));
        }
        Function<BinaryData, Object> messageFactoryToUse = messageFactory != null ? messageFactory : binaryData -> {
            Object instance = SchemaRegistryApacheAvroSerializer.createNoArgumentInstance(typeReference);
            instance.setBodyAsBinaryData(binaryData);
            return instance;
        };
        try {
            schema = AvroSerializer.getSchema(object);
        }
        catch (IllegalArgumentException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
        String schemaFullName = schema.getFullName();
        String schemaString = schema.toString();
        return this.maybeRegisterSchema(this.serializerOptions.getSchemaGroup(), schemaFullName, schemaString).handle((schemaId, sink) -> {
            try {
                byte[] encoded = this.avroSerializer.serialize(object, (String)schemaId);
                MessageWithMetadata serializedMessage = (MessageWithMetadata)messageFactoryToUse.apply(BinaryData.fromBytes((byte[])encoded));
                serializedMessage.setContentType("avro/binary+" + schemaId);
                sink.next((Object)serializedMessage);
                sink.complete();
            }
            catch (SchemaRegistryApacheAvroException e) {
                sink.error((Throwable)((Object)e));
            }
            catch (Exception e) {
                sink.error((Throwable)((Object)new SchemaRegistryApacheAvroException(String.format("Error encountered serializing object: %s with schemaId '%s'.", object, schemaId), e, (String)schemaId)));
            }
        });
    }

    public <T> T deserializeMessageData(MessageWithMetadata message, TypeReference<T> typeReference) {
        return (T)this.deserializeMessageDataAsync(message, typeReference).block();
    }

    public <T> Mono<T> deserializeMessageDataAsync(MessageWithMetadata message, TypeReference<T> typeReference) {
        String schemaId;
        boolean hasPreamble;
        if (message == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'message' cannot be null."));
        }
        if (typeReference == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'typeReference' cannot be null."));
        }
        BinaryData body = message.getBodyAsBinaryData();
        if (Objects.isNull(body)) {
            this.logger.warning("Message provided does not have a BinaryBody, returning empty response.");
            return Mono.empty();
        }
        ByteBuffer contents = body.toByteBuffer();
        if (contents.remaining() == 0) {
            this.logger.warning("Message provided has an empty BinaryBody, returning empty response.");
            return Mono.empty();
        }
        byte[] recordFormatIndicator = new byte[RECORD_FORMAT_INDICATOR_SIZE];
        contents.mark();
        if (contents.remaining() < RECORD_FORMAT_INDICATOR_SIZE) {
            hasPreamble = false;
        } else {
            contents.get(recordFormatIndicator);
            hasPreamble = Arrays.equals(RECORD_FORMAT_INDICATOR, recordFormatIndicator);
        }
        if (hasPreamble) {
            byte[] schemaGuidByteArray = new byte[32];
            contents.get(schemaGuidByteArray);
            schemaId = new String(schemaGuidByteArray, StandardCharsets.UTF_8);
        } else {
            if (CoreUtils.isNullOrEmpty((CharSequence)message.getContentType())) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Cannot deserialize message with no content-type."));
            }
            String[] parts = message.getContentType().split("\\+");
            if (parts.length != 2) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Content type was not in the expected format of MIME type + schema ID. Actual: " + message.getContentType()));
            }
            if (!AVRO_MIME_TYPE.equalsIgnoreCase(parts[0])) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("An avro encoder may only be used on content that is of 'avro/binary' type. Actual: " + message.getContentType()));
            }
            schemaId = parts[1];
            contents.reset();
        }
        return this.schemaRegistryClient.getSchema(schemaId).handle((registryObject, sink) -> {
            byte[] payloadSchema = registryObject.getDefinition().getBytes(StandardCharsets.UTF_8);
            try {
                Object decode = this.avroSerializer.deserialize(contents, payloadSchema, typeReference);
                sink.next(decode);
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    private static <T extends MessageWithMetadata> T createNoArgumentInstance(TypeReference<T> typeReference) {
        Object newObject;
        Optional<Constructor> constructor = Arrays.stream(typeReference.getJavaClass().getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent()) {
            throw new IllegalArgumentException(typeReference.getJavaClass() + "does not have have a no-arg constructor to create a new instance of T with. Use the overload that accepts 'messageFactory'.");
        }
        try {
            newObject = constructor.get().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Could not instantiate '%s' with no-arg constructor.", typeReference.getJavaClass()), e);
        }
        if (!typeReference.getJavaClass().isInstance(newObject)) {
            throw new RuntimeException(String.format("Constructed '%s' object was not an instanceof T '%s'.", newObject, typeReference.getJavaClass()));
        }
        return (T)((MessageWithMetadata)newObject);
    }

    private Mono<String> maybeRegisterSchema(String schemaGroup, String schemaName, String schemaString) {
        if (this.serializerOptions.autoRegisterSchemas()) {
            return this.schemaRegistryClient.registerSchema(schemaGroup, schemaName, schemaString, SchemaFormat.AVRO).map(SchemaProperties::getId);
        }
        return this.schemaRegistryClient.getSchemaProperties(schemaGroup, schemaName, schemaString, SchemaFormat.AVRO).map(properties -> properties.getId());
    }
}

