/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.apacheavro.AvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SerializerOptions;
import java.util.Objects;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public final class SchemaRegistryApacheAvroSerializerBuilder {
    private static final boolean AVRO_SPECIFIC_READER_DEFAULT = false;
    static final int MAX_CACHE_SIZE = 128;
    private final ClientLogger logger = new ClientLogger(SchemaRegistryApacheAvroSerializerBuilder.class);
    private Boolean autoRegisterSchemas = false;
    private Boolean avroSpecificReader = false;
    private SchemaRegistryAsyncClient schemaRegistryAsyncClient;
    private String schemaGroup;

    public SchemaRegistryApacheAvroSerializerBuilder schemaGroup(String schemaGroup) {
        this.schemaGroup = schemaGroup;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder autoRegisterSchema(boolean autoRegisterSchemas) {
        this.autoRegisterSchemas = autoRegisterSchemas;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder avroSpecificReader(boolean avroSpecificReader) {
        this.avroSpecificReader = avroSpecificReader;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder schemaRegistryAsyncClient(SchemaRegistryAsyncClient schemaRegistryAsyncClient) {
        this.schemaRegistryAsyncClient = schemaRegistryAsyncClient;
        return this;
    }

    public SchemaRegistryApacheAvroSerializer buildSerializer() {
        boolean isAutoRegister;
        boolean bl = isAutoRegister = this.autoRegisterSchemas != null && this.autoRegisterSchemas != false;
        if (Objects.isNull(this.schemaRegistryAsyncClient)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'schemaRegistryAsyncClient' cannot be null."));
        }
        if (isAutoRegister && CoreUtils.isNullOrEmpty((CharSequence)this.schemaGroup)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("'schemaGroup' cannot be null or empty when 'autoRegisterSchema' is true."));
        }
        boolean useAvroSpecificReader = this.avroSpecificReader == null ? false : this.avroSpecificReader;
        SerializerOptions options = new SerializerOptions(this.schemaGroup, isAutoRegister, 128);
        AvroSerializer codec = new AvroSerializer(useAvroSpecificReader, EncoderFactory.get(), DecoderFactory.get());
        return new SchemaRegistryApacheAvroSerializer(this.schemaRegistryAsyncClient, codec, options);
    }
}

